/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository.ref.restriction;

import javax.annotation.Nonnull;

public enum RefRestrictionType {
    READ_ONLY("read-only", true),
    NO_DELETES("no-deletes", false),
    FAST_FORWARD_ONLY("fast-forward-only", false),
    PULL_REQUEST_ONLY("pull-request-only", false);

    private final String id;
    private final boolean supportsPermissions;

    private RefRestrictionType(String id, boolean supportsPermissions) {
        this.id = id;
        this.supportsPermissions = supportsPermissions;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public boolean supportsPermissions() {
        return this.supportsPermissions;
    }

    public static RefRestrictionType forId(@Nonnull String id) {
        for (RefRestrictionType value : RefRestrictionType.values()) {
            if (!value.getId().equals(id)) continue;
            return value;
        }
        throw new IllegalArgumentException("There is no RefRestrictionType for ID " + id);
    }
}

