/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.PluginController;
import com.atlassian.stash.internal.plugin.ClusteredPluginPersistentStateStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginStateSplitBrainHandler {
    private static final Logger log = LoggerFactory.getLogger(PluginStateSplitBrainHandler.class);
    private final ExecutorService executorService;
    private final ClusteredPluginPersistentStateStore stateStore;
    private final PluginController pluginController;

    public PluginStateSplitBrainHandler(ExecutorService executorService, ClusteredPluginPersistentStateStore stateStore, PluginController pluginController) {
        this.executorService = executorService;
        this.stateStore = stateStore;
        this.pluginController = pluginController;
    }

    @EventListener
    public void onNetworkPartitionResolved(ClusterNodeAddedEvent event) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try (ClusteredPluginPersistentStateStore.ReadOnlyMarker marker = PluginStateSplitBrainHandler.this.stateStore.markReadOnly();){
                    PluginStateSplitBrainHandler.this.synchronizeState();
                }
            }
        });
    }

    private void synchronizeState() {
        try {
            int pluginsFound = this.pluginController.scanForNewPlugins();
            log.info("{} new plugins were found and installed", (Object)pluginsFound);
        }
        catch (Exception e) {
            log.error("Error while scanning for new plugins", (Throwable)e);
        }
        HashMap<String, Boolean> databaseState = new HashMap<String, Boolean>(this.stateStore.loadRaw().getMap());
        HashMap memoryState = new HashMap(this.stateStore.load().getMap());
        for (Map.Entry entry : memoryState.entrySet()) {
            String key = (String)entry.getKey();
            Boolean value = (Boolean)entry.getValue();
            if (value == null || Objects.equals(value, databaseState.get(key)) || this.isPluginRestartStateKey(key)) {
                databaseState.remove(key);
                continue;
            }
            databaseState.put(key, value == false);
        }
        this.synchronizePlugins(databaseState);
        this.synchronizeModules(databaseState);
    }

    private void synchronizePlugins(Map<String, Boolean> targetState) {
        for (Map.Entry<String, Boolean> dbEntry : targetState.entrySet()) {
            String key = dbEntry.getKey();
            if (!this.isPluginKey(key)) continue;
            try {
                if (dbEntry.getValue().booleanValue()) {
                    log.debug("Enabling plugin {}", (Object)key);
                    this.pluginController.enablePlugins(new String[]{key});
                    continue;
                }
                log.debug("Disabling plugin {}", (Object)key);
                this.pluginController.disablePlugin(key);
            }
            catch (Exception e) {
                log.error("Failed to {} plugin {}", new Object[]{dbEntry.getValue() != false ? "enabled" : "disable", key, e});
            }
        }
    }

    private void synchronizeModules(Map<String, Boolean> targetState) {
        for (Map.Entry<String, Boolean> dbEntry : targetState.entrySet()) {
            String key = dbEntry.getKey();
            if (!this.isPluginModuleKey(key)) continue;
            try {
                if (dbEntry.getValue().booleanValue()) {
                    log.debug("Enabling plugin module {}", (Object)key);
                    this.pluginController.enablePluginModule(key);
                    continue;
                }
                log.debug("Disabling plugin module {}", (Object)key);
                this.pluginController.disablePluginModule(key);
            }
            catch (Exception e) {
                log.error("Failed to {} plugin module {}", new Object[]{dbEntry.getValue() != false ? "enabled" : "disable", key, e});
            }
        }
    }

    private boolean isPluginKey(String key) {
        return key.indexOf(58) == -1 && !this.isPluginRestartStateKey(key);
    }

    private boolean isPluginModuleKey(String key) {
        return key.indexOf(58) != -1 && !this.isPluginRestartStateKey(key);
    }

    private boolean isPluginRestartStateKey(String key) {
        return key.contains("--");
    }
}

