/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartingEvent;
import com.atlassian.stash.internal.lifecycle.StartupProgressEvent;
import com.atlassian.stash.internal.plugin.event.PluginInstallRequestedEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class LifecyclePluginListener {
    private final ApplicationEventPublisher eventPublisher;
    private double started;
    private volatile boolean starting;
    private double total;

    @Autowired
    public LifecyclePluginListener(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public void onInstallingPlugins(PluginInstallRequestedEvent event) {
        this.total = event.getTotal();
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (this.starting) {
            int progress = 45 + (int)((this.started += 1.0) / this.total * 50.0);
            this.eventPublisher.publishEvent((ApplicationEvent)new StartupProgressEvent((Object)this, (Progress)new ProgressImpl("Started " + event.getPlugin().getName(), progress)));
        }
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.starting = false;
    }

    @EventListener
    public void onPluginFrameworkStarting(PluginFrameworkStartingEvent event) {
        this.eventPublisher.publishEvent((ApplicationEvent)new StartupProgressEvent((Object)this, (Progress)new ProgressImpl("Starting plugin framework", 35)));
        this.starting = true;
    }
}

