/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ContextClassLoaderSettingInvocationHandler
implements InvocationHandler {
    private final Object service;

    public ContextClassLoaderSettingInvocationHandler(Object service) {
        this.service = service;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        Thread thread = Thread.currentThread();
        ClassLoader ccl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.service.getClass().getClassLoader());
            Object object = method.invoke(this.service, objects);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            thread.setContextClassLoader(ccl);
        }
    }
}

