/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.logback;

import com.atlassian.stash.internal.ApplicationConstants;
import org.apache.commons.lang3.StringUtils;

public final class LoggingConstants {
    public static final String ACCESS_LOG_FORMAT;
    public static final String FORMAT_DEFAULTING_MDC = "dX";
    public static final String FORMAT_REQUEST_CONTEXT = "request";
    public static final String FORMAT_ENHANCED_THROWABLE = "eThrowable";
    public static final String LOG_FORMAT = "%date %-5level [%thread] %request %logger{36} %m%n%eThrowable";
    public static final String LOGGER_ACCESS;
    public static final String LOGGER_AUDIT;
    public static final String LOGGER_MAIL;
    public static final String MDC_ACCESSLOG_IN_OUT = "a-in-out";
    public static final String MDC_PROTOCOL = "a-protocol";
    public static final String MDC_REMOTE_ADDRESS = "a-remote-address";
    public static final String MDC_REQUEST_BYTES_READ = "a-request-bytes-read";
    public static final String MDC_RESPONSE_BYTES_WRITTEN = "a-response-bytes-written";
    public static final String MDC_STATUS_CODE = "a-status-code";
    public static final String MDC_REQUEST_DETAILS = "a-request-details";
    public static final String MDC_REQUEST_ID = "a-request-id";
    public static final String MDC_REQUEST_LABELS = "a-request-labels";
    public static final String MDC_REQUEST_ACTION = "a-request-action";
    public static final String MDC_REQUEST_TIME = "a-request-time";
    public static final String MDC_SESSION_ID = "a-session-id";
    public static final String MDC_USERNAME = "a-username";
    public static final String PROFILE_LOG_FORMAT;

    private static String dX(String variable) {
        return "%dX{" + variable + "}";
    }

    private LoggingConstants() {
        throw new UnsupportedOperationException("LoggingConstants shouldn't be instantiated even by Reflection!");
    }

    static {
        LOGGER_ACCESS = ApplicationConstants.APPLICATION_KEY + ".access-log";
        LOGGER_AUDIT = ApplicationConstants.APPLICATION_KEY + ".audit-log";
        LOGGER_MAIL = ApplicationConstants.APPLICATION_KEY + ".mail-log";
        ACCESS_LOG_FORMAT = StringUtils.join((Object[])new String[]{LoggingConstants.dX(MDC_REMOTE_ADDRESS), LoggingConstants.dX(MDC_PROTOCOL), "%X{a-in-out}" + LoggingConstants.dX(MDC_REQUEST_ID), LoggingConstants.dX(MDC_USERNAME), "%date", LoggingConstants.dX(MDC_REQUEST_ACTION), LoggingConstants.dX(MDC_REQUEST_DETAILS), LoggingConstants.dX(MDC_STATUS_CODE), LoggingConstants.dX(MDC_REQUEST_BYTES_READ), LoggingConstants.dX(MDC_RESPONSE_BYTES_WRITTEN), LoggingConstants.dX(MDC_REQUEST_LABELS), LoggingConstants.dX(MDC_REQUEST_TIME), LoggingConstants.dX(MDC_SESSION_ID), "%n"}, (String)" | ");
        PROFILE_LOG_FORMAT = StringUtils.join((Object[])new String[]{"%date", "%thread", LoggingConstants.dX(MDC_REQUEST_ID), LoggingConstants.dX(MDC_USERNAME), LoggingConstants.dX(MDC_SESSION_ID) + "%n%m%n"}, (String)" | ");
    }
}

