/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.locale;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.user.AbstractApplicationUserVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.stash.internal.locale.InternalLocaleService;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalDetailedUser;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.google.common.base.MoreObjects;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component(value="localeService")
public class DefaultLocaleService
implements InternalLocaleService {
    private final AuthenticationContext authenticationContext;

    @Autowired
    public DefaultLocaleService(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    @Override
    @Nonnull
    public Locale getLocale() {
        InternalNormalUser user = DefaultLocaleService.getNormalUser(this.authenticationContext.getCurrentUser());
        return (Locale)MoreObjects.firstNonNull((Object)(user != null ? user.getLocale() : null), (Object)LocaleContextHolder.getLocale());
    }

    public static InternalNormalUser getNormalUser(ApplicationUser user) {
        InternalApplicationUser internalUser = user != null ? (InternalApplicationUser)user.accept((ApplicationUserVisitor)new AbstractApplicationUserVisitor<InternalApplicationUser>(){

            public InternalApplicationUser visit(@Nonnull ApplicationUser user) {
                return user instanceof InternalApplicationUser ? (InternalApplicationUser)user : null;
            }

            public InternalApplicationUser visit(@Nonnull DetailedUser user) {
                return ((InternalDetailedUser)user).getDelegate();
            }
        }) : null;
        return internalUser != null ? InternalNormalUser.TO_NORMAL_USER.apply(internalUser) : null;
    }
}

