/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.osgi.factory.descriptor.ComponentImportModuleDescriptor;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class EventListenerRegistrar
implements ApplicationListener<ContextRefreshedEvent>,
DestructionAwareBeanPostProcessor,
BeanFactoryAware,
Ordered {
    private static final Set<String> BLACKLISTED_PLUGIN_KEYS = ImmutableSet.of((Object)"com.atlassian.upm.atlassian-universal-plugin-manager-plugin", (Object)"com.atlassian.activeobjects.activeobjects-plugin", (Object)"com.atlassian.analytics.analytics-client", (Object)"com.atlassian.applinks.applinks-plugin", (Object)"com.atlassian.bitbucket.server.bitbucket-git", (Object)"com.atlassian.crowd.embedded.admin", (Object[])new String[]{"com.atlassian.oauth.admin", "com.atlassian.oauth.consumer", "com.atlassian.oauth.consumer.sal", "com.atlassian.oauth.serviceprovider", "com.atlassian.oauth.serviceprovider.sal", "com.atlassian.plugins.rest.atlassian-rest-module", "com.atlassian.soy.soy-template-plugin", "com.atlassian.templaterenderer.api", "com.atlassian.templaterenderer.atlassian-template-renderer-velocity1.6-plugin", "com.atlassian.auiplugin"});
    private static final Logger log = LoggerFactory.getLogger(EventListenerRegistrar.class);
    private ConfigurableBeanFactory beanFactory;
    private EventPublisher eventPublisher;
    private final String eventPublisherName;
    private final Map<String, Object> toBeRegistered = Maps.newHashMap();
    private final ListenerHandlersConfiguration listenerHandlersConfiguration;
    private final ConcurrentMap<String, ConcurrentMap<String, Object>> eventListenersFromPlugins = Maps.newConcurrentMap();
    private volatile boolean springContextRefreshed;

    public EventListenerRegistrar(String eventPublisherName, ListenerHandlersConfiguration listenerHandlersConfiguration) {
        this.eventPublisherName = eventPublisherName;
        this.listenerHandlersConfiguration = listenerHandlersConfiguration;
    }

    public int getOrder() {
        return 1;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        this.springContextRefreshed = true;
    }

    @PluginEventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        ModuleDescriptor moduleDescriptor = event.getModule();
        Plugin plugin = event.getModule().getPlugin();
        if (BLACKLISTED_PLUGIN_KEYS.contains(plugin.getKey())) {
            return;
        }
        if (!moduleDescriptor.getClass().equals(ComponentImportModuleDescriptor.class) && moduleDescriptor.getModuleClass() != null && !moduleDescriptor.getModuleClass().equals(Void.class)) {
            Object module;
            try {
                module = moduleDescriptor.getModule();
                Object module2 = moduleDescriptor.getModule();
                if (module != module2) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
            try {
                this.registerModuleIfEventListener(plugin.getKey(), moduleDescriptor.getKey(), module);
            }
            catch (Throwable t) {
                if (!(t instanceof NoClassDefFoundError)) {
                    log.info("Error registering eventlisteners for module " + moduleDescriptor.getCompleteKey() + "; skipping.", t);
                }
                log.debug("Skipping {} because not all referenced classes are visible from the classloader.", (Object)moduleDescriptor.getCompleteKey());
            }
        }
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        Plugin plugin = event.getPlugin();
        Map listeners = (Map)this.eventListenersFromPlugins.remove(plugin.getKey());
        if (listeners != null) {
            for (Object eventListener : listeners.values()) {
                this.eventPublisher.unregister(eventListener);
            }
        }
    }

    @PluginEventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        Object module;
        ModuleDescriptor moduleDescriptor = event.getModule();
        Map modules = (Map)this.eventListenersFromPlugins.get(moduleDescriptor.getPluginKey());
        Object v0 = module = modules != null ? modules.remove(moduleDescriptor.getKey()) : null;
        if (module != null) {
            this.eventPublisher.unregister(module);
        }
    }

    @PreDestroy
    public void onShutdown() {
        if (this.eventPublisher != null) {
            this.eventPublisher.unregister((Object)this);
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (beanName.equals(this.eventPublisherName)) {
            this.eventPublisher = (EventPublisher)bean;
            this.eventPublisher.register((Object)this);
            for (Object object : this.toBeRegistered.values()) {
                this.eventPublisher.register(object);
            }
            this.toBeRegistered.clear();
        }
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.eventPublisher != null) {
            this.eventPublisher.unregister(bean);
        } else {
            this.toBeRegistered.remove(beanName);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.springContextRefreshed) {
            return bean;
        }
        BeanDefinition beanDefinition = null;
        try {
            if (this.beanFactory != null) {
                beanDefinition = this.beanFactory.getMergedBeanDefinition(beanName);
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (beanDefinition == null || beanDefinition.isSingleton()) {
            this.registerBeanIfEventListener(beanName, bean);
        }
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
        }
    }

    private void registerBeanIfEventListener(String beanName, Object bean) {
        if (this.hasListenerHandler(bean)) {
            this.registerEventListener(beanName, bean);
        }
    }

    private void registerModuleIfEventListener(String pluginKey, String moduleKey, Object bean) {
        if (this.hasListenerHandler(bean)) {
            this.getModulesForPluginKey(pluginKey).put(moduleKey, bean);
            this.registerEventListener(pluginKey + ":" + moduleKey, bean);
        }
    }

    private boolean hasListenerHandler(Object bean) {
        if (bean == null) {
            return false;
        }
        for (ListenerHandler handler : this.listenerHandlersConfiguration.getListenerHandlers()) {
            if (handler.getInvokers(bean).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void registerEventListener(String beanName, Object bean) {
        log.trace("Registering {} instance as an eventlistener", (Object)bean.getClass().getName());
        if (this.eventPublisher != null) {
            this.eventPublisher.register(bean);
        } else {
            this.toBeRegistered.put(beanName, bean);
        }
    }

    private Map<String, Object> getModulesForPluginKey(String pluginKey) {
        Map map = (Map)this.eventListenersFromPlugins.get(pluginKey);
        if (map == null) {
            ConcurrentMap created = Maps.newConcurrentMap();
            map = (Map)MoreObjects.firstNonNull(this.eventListenersFromPlugins.putIfAbsent(pluginKey, created), (Object)created);
        }
        return map;
    }
}

