/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.internal.concurrent.CompositeTransferableState;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class StateTransferringExecutor
implements Executor,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(StateTransferringExecutor.class);
    private final Executor delegate;
    private volatile List<StatefulService> services;

    public StateTransferringExecutor(Executor delegate) {
        this.delegate = delegate;
        this.services = ImmutableList.of();
    }

    @Override
    public void execute(@Nonnull Runnable runnable) {
        this.delegate.execute(this.wrap(runnable));
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.services = ImmutableList.copyOf(event.getApplicationContext().getBeansOfType(StatefulService.class).values());
    }

    protected void clearServices() {
        this.services = ImmutableList.of();
    }

    protected TransferableState getState() {
        return new CompositeTransferableState(Collections2.transform(this.services, StatefulService.TO_STATE));
    }

    protected Runnable wrap(Runnable runnable) {
        return new StateTransferringRunnable(runnable, this.getState());
    }

    protected static class StateTransferringRunnable
    implements Runnable {
        private final Runnable delegate;
        private final TransferableState state;

        public StateTransferringRunnable(Runnable delegate, TransferableState state) {
            this.delegate = delegate;
            this.state = state;
        }

        @Override
        public void run() {
            try {
                this.state.apply();
                try {
                    this.delegate.run();
                }
                finally {
                    this.state.remove();
                }
            }
            catch (Error | RuntimeException e) {
                log.error("Error while processing asynchronous task", e);
                throw e;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StateTransferringRunnable)) {
                return false;
            }
            StateTransferringRunnable that = (StateTransferringRunnable)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

