/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.bitbucket.Product;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.home.HomeLock;
import com.atlassian.stash.internal.home.HomeLockDeniedException;
import com.atlassian.stash.internal.home.HomeLockFailedException;
import java.io.File;
import java.io.IOException;
import java.nio.channels.OverlappingFileLockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeLockAcquirer {
    protected static final Logger log = LoggerFactory.getLogger(HomeLockAcquirer.class);
    protected final File homeDir;
    private volatile HomeLock lock;

    public HomeLockAcquirer(File homeDir) {
        this.homeDir = homeDir;
    }

    public void lock() {
        if (this.lock != null) {
            throw new IllegalStateException("The lock is already held by this instance and cannot be reacquired");
        }
        HomeLock homeLock = this.createHomeLock(this.homeDir);
        try {
            if (homeLock.lock()) {
                log.info("Successfully acquired lock on home directory {}", (Object)this.homeDir);
            } else {
                log.error("Home directory {} has already been locked by another instance", (Object)this.homeDir);
                this.onLockDenied(homeLock);
            }
        }
        catch (OverlappingFileLockException e) {
            log.error("The current JVM holds an overlapping lock on home directory {}. Are there two {} instances deployed in the same application server?", (Object)this.homeDir, (Object)ApplicationConstants.PRODUCT_NAME);
            this.onLockFailed(homeLock, e);
        }
        catch (IOException e) {
            log.error("Lock file {} cannot be obtained in home directory {}. Does {} have write permission on that directory? Is file locking enabled for the filesystem?", new Object[]{homeLock, this.homeDir, System.getProperty("user.name"), e});
            this.onLockFailed(homeLock, e);
        }
        this.lock = homeLock;
    }

    public void unlock() {
        if (this.lock == null) {
            return;
        }
        log.info("Releasing lock on {}", (Object)this.homeDir);
        try {
            this.lock.close();
        }
        finally {
            this.lock = null;
        }
    }

    protected HomeLock createHomeLock(File homeDir) {
        return new HomeLock(homeDir, false);
    }

    protected String getLockDeniedMessage(HomeLock lock) {
        return String.format("Home directory '%2$s' is already locked by another running instance of %1$s.\n\nPlease stop the other instance of %1$s and restart this instance.\n\nIf you are absolutely certain that no other instance of %1$s is running, please remove the lock file '%3$s' and restart this instance.", Product.NAME, this.homeDir.getAbsolutePath(), lock);
    }

    protected String getFailedMessage(HomeLock lock) {
        return String.format("Unable to create and acquire %4$s lock file '%3$s' for %1$s home directory '%2$s'.\n\nPlease ensure that the user running %1$s has permission to write to this directory.\n\nIf this is already the case, please check the logs for more information.", Product.NAME, this.homeDir.getAbsolutePath(), lock, lock.isShared() ? "shared" : "exclusive");
    }

    protected boolean isReLockRequired() {
        return this.isReLockRequired(this.lock);
    }

    protected boolean isReLockRequired(HomeLock currentLock) {
        return currentLock == null;
    }

    private void onLockDenied(HomeLock lock) {
        throw new HomeLockDeniedException(this.getLockDeniedMessage(lock));
    }

    private void onLockFailed(HomeLock lock, Exception e) {
        throw new HomeLockFailedException(this.getFailedMessage(lock), e);
    }
}

