/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.bitbucket.test.ProductTopology;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.Option;
import com.atlassian.pageobjects.elements.Options;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.SelectElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import com.atlassian.webdriver.bitbucket.page.admin.UserDirectorySettingsPage;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class UserDirectoriesPage
extends BitbucketAdminPage {
    @ElementBy(cssSelector=".aui-page-header a[target=_help]")
    private PageElement helpLink;
    @ElementBy(id="new-directory")
    private PageElement addDirectoryButton;
    @ElementBy(id="new-directory-type")
    private SelectElement directoryTypeSelector;
    @ElementBy(cssSelector="#new-directory-form input")
    private PageElement nextButton;

    public UserDirectoriesPage() {
    }

    public UserDirectoriesPage(String webSudoPassword) {
        super(webSudoPassword);
    }

    @Override
    @WaitUntil
    public void doWait() {
        super.doWait();
        if (ProductTopology.get() == ProductTopology.BITBUCKET_STANDALONE) {
            return;
        }
        Poller.waitUntil((TimedQuery)this.rollingUpgradeBannerIsVisible(), (Matcher)CoreMatchers.is((Object)true), (Poller.WaitTimeout)Poller.by((long)5L, (TimeUnit)TimeUnit.SECONDS));
    }

    public String getUrl() {
        return "/plugins/servlet/embedded-crowd/directories/list";
    }

    public UserDirectoriesPage popupAddDirectoryDialog() {
        this.addDirectoryButton.click();
        return (UserDirectoriesPage)this.pageBinder.bind(UserDirectoriesPage.class, new Object[0]);
    }

    public UserDirectoriesPage setDirectoryType(String directoryType) {
        this.directoryTypeSelector.select((Option)Options.text((String)directoryType));
        return this;
    }

    public String getHelpLinkTitle() {
        return this.helpLink.getAttribute("title");
    }

    public String getHelpLinkURL() {
        return this.helpLink.getAttribute("href");
    }

    public UserDirectorySettingsPage gotoNewDirectorySettingsPage() {
        this.nextButton.click();
        return (UserDirectorySettingsPage)this.pageBinder.bind(UserDirectorySettingsPage.class, new Object[0]);
    }
}

