/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.SearchableSelector;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.FileBrowserPage;
import com.google.gson.JsonParser;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class RepositoryForkCreatePage
extends BitbucketPage {
    private static final JsonParser PARSER = new JsonParser();
    private final String projectKey;
    private final String repoSlug;
    @ElementBy(id="name")
    private PageElement repoNameField;
    @ElementBy(id="fork-repo-submit")
    private PageElement submitButton;
    @ElementBy(id="toProjectSelector")
    private PageElement toProjectSelector;

    public RepositoryForkCreatePage(String projectKey, String repoSlug) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
    }

    public String getUrl() {
        return "/projects/" + this.projectKey + "/repos/" + this.repoSlug + "?fork";
    }

    public RepositoryForkCreatePage setProject(String projectKey) {
        SearchableSelector selector = (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.elementFinder.find(By.id((String)"toProjectSelector")), By.id((String)"inline-dialog-toProjectSelector-dialog"), this.elementFinder.find(By.id((String)"toProjectSelector-field"))});
        if (!((Boolean)selector.getDialog().isOpen().byDefaultTimeout()).booleanValue()) {
            selector.open();
            Poller.waitUntilTrue((TimedQuery)selector.getDialog().isOpen());
        }
        selector.getDialog().filterBy(projectKey).selectItemByName(projectKey);
        return this;
    }

    public RepositoryForkCreatePage setRepoName(String repoName) {
        this.repoNameField.clear().type(new CharSequence[]{repoName});
        Poller.waitUntil((TimedQuery)this.repoNameField.timed().getValue(), (Matcher)Matchers.equalTo((Object)repoName));
        return this;
    }

    public FileBrowserPage submit() {
        String projectAttributes = this.toProjectSelector.find(By.className((String)"project")).getAttribute("data-project");
        String newProjectKey = PARSER.parse(projectAttributes).getAsJsonObject().get("key").getAsString();
        String newRepoSlug = this.repoNameField.getValue();
        this.submitButton.click();
        FileBrowserPage page = (FileBrowserPage)this.pageBinder.bind(FileBrowserPage.class, new Object[]{newProjectKey, newRepoSlug});
        Poller.waitUntilTrue((TimedQuery)page.isHereTimed());
        return page;
    }
}

