/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.pageobjects.element.Flag;
import com.atlassian.bitbucket.pageobjects.element.WhatsNew;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementActions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.BitbucketHeader;
import com.atlassian.webdriver.bitbucket.element.ErrorDialog;
import com.atlassian.webdriver.bitbucket.page.AbstractPage;
import com.atlassian.webdriver.bitbucket.page.LogoutPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.KeyboardShortcuts;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;

public abstract class BitbucketPage
extends AbstractPage {
    private static final List<Integer> ERROR_CODE_WITH_PAGES = ImmutableList.of((Object)Response.Status.BAD_REQUEST.getStatusCode(), (Object)Response.Status.UNAUTHORIZED.getStatusCode(), (Object)Response.Status.NOT_FOUND.getStatusCode(), (Object)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    @Inject
    protected PageElementActions actions;
    @ElementBy(id="content")
    protected PageElement content;
    @ElementBy(id="footer")
    protected PageElement footer;
    @ElementBy(id="header")
    private PageElement header;
    @ElementBy(id="websudo-banner")
    private PageElement webSudoBanner;

    public void assertIsError(String expectedMessage, int expectedError) {
        if (ERROR_CODE_WITH_PAGES.contains(expectedError)) {
            PageElement errorImage = this.content.find(By.className((String)"error-image"));
            Assert.assertTrue((String)"Error image not present", (boolean)errorImage.isPresent());
            Assert.assertTrue((String)("Error image does not have expected class _" + expectedError), (boolean)errorImage.hasClass("_" + expectedError));
            Assert.assertThat((Object)this.content.getText(), (Matcher)Matchers.containsString((String)expectedMessage));
        } else {
            Assert.assertThat((Object)this.elementFinder.find(By.tagName((String)"h1")).getText(), (Matcher)Matchers.containsString((String)String.valueOf(expectedError)));
            if (expectedMessage != null) {
                Assert.assertThat((Object)this.elementFinder.find(By.tagName((String)"body")).getText(), (Matcher)Matchers.containsString((String)expectedMessage));
            }
        }
    }

    public void closeFlags() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)".aui-flag > .aui-message")).timed().isVisible());
        this.doCloseFlags();
    }

    public void closeFlagsIfVisible() {
        if (this.elementFinder.find(By.cssSelector((String)".aui-flag > .aui-message")).isVisible()) {
            this.doCloseFlags();
        }
    }

    public Collection<String> getAlerts() {
        PageElement alertsTrigger = this.header.find(By.id((String)"alerts-trigger"));
        alertsTrigger.click();
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.cssSelector((String)"#inline-dialog-alerts-content aui-spinner")).timed().isPresent());
        return ElementUtils.getElementTexts(this.body.findAll(By.cssSelector((String)".alerts-list .aui-message")));
    }

    public Collection<String> getAuiBannerErrorMessages() {
        return ElementUtils.getElementTexts(this.body.findAll(By.className((String)"aui-banner-error")));
    }

    public Collection<String> getAuiBannerMessages() {
        return ElementUtils.getElementTexts(this.body.findAll(By.className((String)"aui-banner")));
    }

    public Collection<String> getAuiErrorMessages() {
        List errors = this.body.findAll(By.className((String)"aui-message-error"), TimeoutType.DEFAULT);
        return ElementUtils.getElementTexts(errors);
    }

    public Collection<String> getAuiFlagErrorMessages() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"aui-flag")).timed().isVisible());
        return this.getAuiErrorMessages();
    }

    public PageElement getAuiFlagErrorMessagesLink() {
        PageElement auiErrorFlag = this.elementFinder.find(By.className((String)"aui-flag"));
        Poller.waitUntilTrue((TimedQuery)auiErrorFlag.timed().isVisible());
        return auiErrorFlag.find(By.cssSelector((String)"a.aui-button-link"));
    }

    public Collection<String> getAuiMessages() {
        List errors = this.body.findAll(By.className((String)"aui-message"), TimeoutType.DEFAULT);
        return ElementUtils.getElementTexts(errors);
    }

    public Collection<String> getAuiSuccessMessages() {
        return ElementUtils.getElementTexts(this.body.findAll(By.className((String)"aui-message-success")));
    }

    public Collection<String> getAuiWarningMessages() {
        return ElementUtils.getElementTexts(this.body.findAll(By.className((String)"aui-message-warning")));
    }

    public String getDocumentationLink() {
        return this.driver.findElement(By.id((String)"com.atlassian.bitbucket.server.bitbucket-server-web-fragments-help-menu")).findElement(By.tagName((String)"a")).getAttribute("href");
    }

    public PageElement getDropAccessLink() {
        return this.webSudoBanner.find(By.className((String)"websudo-banner-drop-access"));
    }

    public ErrorDialog getErrorDialog() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"error-dialog")).timed().isVisible());
        return (ErrorDialog)((Object)this.body.findAll(By.className((String)"error-dialog"), ErrorDialog.class).get(0));
    }

    public List<String> getFieldsWithErrors(PageElement form) {
        return Lists.newArrayList(ElementUtils.getFieldsWithErrors(form));
    }

    public List<Flag> getFlags() {
        By flagSelector = By.cssSelector((String)".atlaskit-portal [role='alert'] > div:first-child");
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(flagSelector).timed().isVisible());
        return this.elementFinder.findAll(flagSelector).stream().map(ElementUtils.bind(this.pageBinder, Flag.class, new Object[0])).collect(Collectors.toList());
    }

    public BitbucketHeader getHeader() {
        return (BitbucketHeader)this.pageBinder.bind(BitbucketHeader.class, new Object[]{this.header});
    }

    public PageElement getWebSudoBanner() {
        return this.webSudoBanner;
    }

    public WhatsNew getWhatsNew() {
        return (WhatsNew)this.pageBinder.bind(WhatsNew.class, new Object[]{this.elementFinder});
    }

    public boolean hasAdminLink() {
        return this.header.find(By.cssSelector((String)"a.admin-link")).isPresent();
    }

    public TimedCondition isPermissionDenied() {
        return this.elementFinder.find(By.className((String)"_401")).timed().isPresent();
    }

    public LogoutPage logout() {
        return this.getHeader().logout(LogoutPage.class);
    }

    @Override
    public void scrollToTop() {
        super.scrollToTop();
        Poller.waitUntilTrue((TimedQuery)this.header.find(By.id((String)"logo")).timed().isVisible());
    }

    public BitbucketPage switchToNewWindow(Integer window) {
        ArrayList browserTabs = new ArrayList(this.driver.getWindowHandles());
        this.driver.switchTo().window((String)browserTabs.get(window));
        return this;
    }

    protected TimedCondition rollingUpgradeBannerIsVisible() {
        return this.body.timed().hasText("Bitbucket is being upgraded, with nodes running different versions. Avoid installing or upgrading apps, as this could result in unexpected errors.");
    }

    protected void useShortcut(CharSequence key) {
        KeyboardShortcuts.press(this.body, key);
    }

    private void doCloseFlags() {
        try {
            this.elementFinder.findAll(By.cssSelector((String)".aui-flag > .aui-message > .aui-close-button")).forEach(close -> this.actions.moveToElement(close).click().perform());
        }
        catch (MoveTargetOutOfBoundsException moveTargetOutOfBoundsException) {
            // empty catch block
        }
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.className((String)"aui-message")).timed().isVisible());
    }
}

