/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public abstract class BaseMergeStrategiesSettingsPage
extends BaseSidebarPage {
    @ElementBy(className="cancel-button")
    protected PageElement cancelLink;
    @ElementBy(id="commit-message-template-behaviour-field")
    protected PageElement commitMessageTemplateBehaviourRadios;
    @ElementBy(className="commit-message-template-body")
    protected PageElement commitMessageTemplateBodyInput;
    @ElementBy(id="commit-message-template-title-field")
    protected PageElement commitMessageTemplateTitleInput;
    @ElementBy(id="merge-strategies")
    protected PageElement mergeConfig;
    @ElementBy(className="save-button")
    protected PageElement saveButton;
    @ElementBy(cssSelector="[data-testid='save-success-flag']")
    protected PageElement updateSuccessfulMessage;
    @ElementBy(cssSelector="[data-testid='enable-strategy']")
    protected PageElement enableActionMenu;
    @ElementBy(cssSelector="[data-testid='disable-strategy']")
    protected PageElement disableActionMenu;
    @ElementBy(cssSelector="[data-testid='set-default-strategy']")
    protected PageElement setAsDefaultMenu;
    @ElementBy(cssSelector="[data-testid='commit-message-template-title-error']")
    protected PageElement commitMessageTitleErrorField;
    @ElementBy(cssSelector="[data-testid='commit-message-template-body-error']")
    protected PageElement commitMessageBodyErrorField;

    public void clickCancel() {
        this.scrollToBottom();
        this.cancelLink.click();
    }

    public void clickSave() {
        this.scrollToBottom();
        this.saveButton.click();
        Poller.waitUntilTrue((TimedQuery)this.updateSuccessfulMessage.timed().isVisible());
    }

    public String getCommitMessageTemplateBody() {
        return this.commitMessageTemplateBodyInput.getValue();
    }

    public String getCommitMessageTemplateTitle() {
        return this.commitMessageTemplateTitleInput.getValue();
    }

    public boolean isCommitMessageTemplateTitleInputEnabled() {
        return this.commitMessageTemplateTitleInput.withTimeout(TimeoutType.UI_ACTION).isEnabled();
    }

    public boolean isCommitMessageTemplateBodyInputEnabled() {
        return this.commitMessageTemplateBodyInput.withTimeout(TimeoutType.UI_ACTION).isEnabled();
    }

    public List<String> getErrors() {
        return this.mergeConfig.findAll(By.className((String)"merge-settings-error")).stream().map(PageElement::getText).collect(Collectors.toList());
    }

    public PageElement getCommitMessageTemplateTitleError() {
        return this.commitMessageTitleErrorField;
    }

    public PageElement getCommitMessageTemplateBodyError() {
        return this.commitMessageBodyErrorField;
    }

    public int getCommitSummaries() {
        return Integer.parseInt(this.mergeConfig.find(By.id((String)"commit-summaries-field")).getValue());
    }

    public PageElement getSaveButton() {
        return this.saveButton;
    }

    public void disableMergeStrategies(Set<String> strategyIds) {
        this.mergeConfig.findAll(By.cssSelector((String)".merge-strategy-row")).stream().filter(element -> {
            String id = element.getAttribute("data-value");
            PageElement enabledLozenge = element.find(By.cssSelector((String)"[data-testid='enabled-lozenge']"));
            return enabledLozenge.isPresent() && strategyIds.contains(id);
        }).forEach(element -> {
            PageElement meatballMenu = element.find(By.cssSelector((String)"[data-testid='actions-menu-button']"));
            meatballMenu.click();
            Poller.waitUntilTrue((TimedQuery)this.disableActionMenu.timed().isVisible());
            this.disableActionMenu.click();
        });
    }

    public void enableMergeStrategies(Set<String> strategyIds) {
        this.mergeConfig.findAll(By.cssSelector((String)".merge-strategy-row")).stream().filter(element -> {
            String id = element.getAttribute("data-value");
            PageElement disabledLozenge = element.find(By.cssSelector((String)"[data-testid='disabled-lozenge']"));
            return disabledLozenge.isPresent() && strategyIds.contains(id);
        }).forEach(element -> {
            PageElement meatballMenu = element.find(By.cssSelector((String)"[data-testid='actions-menu-button']"));
            meatballMenu.click();
            Poller.waitUntilTrue((TimedQuery)this.enableActionMenu.timed().isVisible());
            this.enableActionMenu.click();
        });
    }

    public String getDefaultMergeStrategy() {
        return this.mergeConfig.find(By.cssSelector((String)".default-strategy")).getAttribute("data-value");
    }

    public List<String> getEnabledMergeStrategies() {
        return (List)this.mergeConfig.findAll(By.cssSelector((String)"[data-testid='enabled-lozenge']")).stream().map(pageElement -> pageElement.find(By.xpath((String)"../.."))).map(pageElement -> pageElement.getAttribute("data-value")).collect(MoreCollectors.toImmutableList());
    }

    public boolean isCommitMessageTemplateEnabled() {
        return this.mergeConfig.find(By.cssSelector((String)"[name=\"template-behaviour\"]:checked")).getValue().equals("true");
    }

    public TimedCondition isSuccessfulUpdate() {
        return this.updateSuccessfulMessage.timed().isPresent();
    }

    public void scrollSlightly() {
        ElementUtils.scrollDocument(this.mergeConfig, 200);
    }

    public void setCommitSummaries(String value) {
        this.mergeConfig.find(By.id((String)"commit-summaries-field")).clear().type(new CharSequence[]{value});
    }

    public void setCommitMessageTemplateBody(String value) {
        this.commitMessageTemplateBodyInput.clear().type(new CharSequence[]{value});
    }

    public void setCommitMessageTemplateEnabled(boolean enabled) {
        this.scrollToBottom();
        this.mergeConfig.find(By.cssSelector((String)("input[name='template-behaviour'][value='" + enabled + "']"))).click();
        Poller.waitUntil((TimedQuery)this.commitMessageTemplateTitleInput.timed().isEnabled(), (Matcher)Matchers.equalTo((Object)enabled));
        Poller.waitUntil((TimedQuery)this.commitMessageTemplateBodyInput.timed().isEnabled(), (Matcher)Matchers.equalTo((Object)enabled));
    }

    public void setCommitMessageTemplateTitle(String value) {
        this.commitMessageTemplateTitleInput.clear().type(new CharSequence[]{value});
    }

    public void setDefaultMergeStrategy(String defaultId) {
        PageElement strategyRow = this.mergeConfig.find(By.cssSelector((String)("[data-value='" + defaultId + "']")));
        PageElement meatballMenu = strategyRow.find(By.cssSelector((String)"[data-testid='actions-menu-button']"));
        meatballMenu.click();
        Poller.waitUntilTrue((TimedQuery)this.setAsDefaultMenu.timed().isVisible());
        this.setAsDefaultMenu.click();
    }
}

