/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.next;

import com.atlassian.bitbucket.pageobjects.element.next.FileContent;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.next.DiffFileContent;
import com.google.common.base.Supplier;
import java.util.List;
import org.junit.Assert;
import org.openqa.selenium.By;

public class SideBySideDiffFileContent
extends DiffFileContent {
    public SideBySideDiffFileContent(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    @Override
    public void waitUntilFileContentLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.find(By.className((String)"to-gutter-col")).timed().isPresent());
        super.waitUntilFileContentLoaded();
    }

    private List<Line> getLines(final String lineSide) {
        return this.waitForSourceContainer(new Supplier<List<Line>>(){

            public List<Line> get() {
                return SideBySideDiffFileContent.this.findAll(By.cssSelector((String)(".diff-line[data-line-side=\"" + lineSide + "\"]")), Line.class);
            }
        });
    }

    public List<Line> getFromLines() {
        return this.getLines("FROM");
    }

    public Lineset getLines(int fromStart, int toStart) {
        return new Lineset(this, fromStart, toStart);
    }

    public List<Line> getToLines() {
        return this.getLines("TO");
    }

    public static class Lineset {
        private final SideBySideDiffFileContent fileContent;
        private final int fromStart;
        private final int toStart;

        private Lineset(SideBySideDiffFileContent fileContent, int fromStart, int toStart) {
            this.fileContent = fileContent;
            this.fromStart = fromStart;
            this.toStart = toStart;
        }

        public void assertHasFocus() {
            int fromFocus = Lineset.getFocusedLineNumber(this.fileContent, "from");
            int toFocus = Lineset.getFocusedLineNumber(this.fileContent, "to");
            if (this.fromStart > -1) {
                Assert.assertEquals((long)this.fromStart, (long)fromFocus);
            } else if (this.toStart > -1) {
                Assert.assertEquals((long)this.toStart, (long)toFocus);
            }
        }

        private static int getFocusedLineNumber(SideBySideDiffFileContent fileContent, String side) {
            String attribute = "from".equals(side) ? "data-line-source" : "data-line-destination";
            PageElement element = fileContent.find(By.cssSelector((String)("." + side + "-gutter.active-diff-line")));
            if (element.isPresent()) {
                return Integer.parseInt(element.getAttribute(attribute));
            }
            return -1;
        }
    }

    public static class Line
    extends FileContent.Line {
        public Line(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public Line(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }
    }
}

