/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;

public abstract class SshKeyRow<T>
extends LegacyElementPageObject {
    @Inject
    private PageElementFinder elementFinder;
    @ElementBy(className="ssh-key-label")
    private PageElement sshKeyLabel;

    protected SshKeyRow(@Nonnull PageElement pageElement) {
        super(pageElement);
    }

    public SshKeyRow(By locator) {
        super(locator);
    }

    public SshKeyRow(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public SshKeyRow(By locator, WebDriverLocatable parent) {
        super(locator, parent);
    }

    public SshKeyRow(By locator, WebDriverLocatable parent, TimeoutType timeoutType) {
        super(locator, parent, timeoutType);
    }

    public SshKeyRow(WebDriverLocatable locatable, TimeoutType timeoutType) {
        super(locatable, timeoutType);
    }

    public void clickDelete() {
        PageElement dropdownTriggerButton = this.find(By.cssSelector((String)"[data-testid='ssh-key-dropdown-trigger-button']"));
        dropdownTriggerButton.click();
        PageElement deleteActionButton = this.elementFinder.find(By.cssSelector((String)"[data-testid='ssh-key-actions-delete']"));
        ElementUtils.makeVisible(deleteActionButton).click();
        PageElement deleteDialog = this.elementFinder.find(By.cssSelector((String)"[data-testid='ssh-key-delete-modal']"));
        Poller.waitUntilTrue((TimedQuery)deleteDialog.timed().isVisible());
        PageElement deleteButton = deleteDialog.find(By.className((String)"ssh-key-delete-dialog-delete-button"));
        Poller.waitUntilTrue((TimedQuery)deleteButton.timed().isVisible());
        Poller.waitUntilFalse((TimedQuery)deleteButton.timed().hasAttribute("disabled", "true"));
        deleteButton.click();
        Poller.waitUntilFalse((TimedQuery)deleteDialog.timed().isVisible());
    }

    public String getKeyLabel() {
        Poller.waitUntilTrue((TimedQuery)this.isKeyLabelVisible());
        return this.sshKeyLabel.getText();
    }

    public TimedCondition isKeyLabelVisible() {
        return this.sshKeyLabel.timed().isVisible();
    }

    protected abstract T bindToNextPage();
}

