/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.pageobjects.DefaultProductInstance;
import com.atlassian.pageobjects.Page;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.ProductInstance;
import com.atlassian.pageobjects.TestedProduct;
import com.atlassian.pageobjects.TestedProductFactory;
import com.atlassian.pageobjects.Tester;
import com.atlassian.pageobjects.binder.InjectPageBinder;
import com.atlassian.pageobjects.binder.StandardModule;
import com.atlassian.pageobjects.elements.ElementModule;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutsModule;
import com.atlassian.webdriver.WebDriverModule;
import com.atlassian.webdriver.bitbucket.JavascriptLocalStorage;
import com.atlassian.webdriver.bitbucket.JavascriptSessionStorage;
import com.atlassian.webdriver.bitbucket.page.AbstractPage;
import com.atlassian.webdriver.pageobjects.DefaultWebDriverTester;
import com.atlassian.webdriver.pageobjects.WebDriverTester;
import com.atlassian.webdriver.utils.WebDriverUtil;
import com.google.inject.Binder;
import com.google.inject.Module;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.SessionStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBitbucketTestedProduct
implements TestedProduct<WebDriverTester> {
    private static final Logger log = LoggerFactory.getLogger(AbstractBitbucketTestedProduct.class);
    protected final PageBinder pageBinder;
    protected final WebDriverTester webDriverTester;
    protected final ProductInstance productInstance;

    public AbstractBitbucketTestedProduct(TestedProductFactory.TesterFactory<WebDriverTester> testerFactory, @Nonnull ProductInstance productInstance) {
        this.productInstance = this.rewriteBaseUrl(Objects.requireNonNull(productInstance, "productInstance"));
        this.webDriverTester = testerFactory == null ? new DefaultWebDriverTester() : (WebDriverTester)testerFactory.create();
        this.pageBinder = new InjectPageBinder(this.productInstance, (Tester)this.webDriverTester, new Module[]{new StandardModule((TestedProduct)this), new ExtendedWebDriverModule(this), new ElementModule(), new TimeoutsModule()});
        this.overridePages();
    }

    public PageBinder getPageBinder() {
        return this.pageBinder;
    }

    public ProductInstance getProductInstance() {
        return this.productInstance;
    }

    public WebDriverTester getTester() {
        return this.webDriverTester;
    }

    public <P extends Page> P visit(Class<P> pageClass, Object ... args) {
        Page page = this.pageBinder.navigateToAndBind(pageClass, args);
        if (page instanceof AbstractPage) {
            AbstractPage bitbucketPage = (AbstractPage)page;
            Poller.waitUntilTrue((TimedQuery)bitbucketPage.isHereTimed());
        }
        return (P)page;
    }

    protected abstract void overridePages();

    protected String getHost() {
        return System.getProperty("test.host", "localhost");
    }

    private ProductInstance rewriteBaseUrl(ProductInstance original) {
        if (DefaultFuncTestData.RUNNING_VIA_DOCKER) {
            try {
                String newAddress = InetAddress.getLocalHost().getHostAddress();
                return this.changeBaseUrl(original, newAddress);
            }
            catch (UnknownHostException e) {
                log.warn("Couldn't get the required host information for a docker container. Will fall back to processing as if docker.host was false");
            }
            catch (URISyntaxException e) {
                log.warn("The URI created for the docker host contained invalid syntax. Will fall back to processing as if docker.host was false");
            }
        }
        if (original.getBaseUrl().contains("localhost") || System.getProperty("test.url") != null) {
            return original;
        }
        String updatedBaseUrl = DefaultFuncTestData.getBaseURL();
        try {
            return this.changeBaseUrl(original, this.getHost());
        }
        catch (URISyntaxException e) {
            log.warn("Could not parse baseUrl ({}) for instance {}. Using default {} instead", new Object[]{original.getBaseUrl(), original.getInstanceId(), updatedBaseUrl});
            return new DefaultProductInstance(updatedBaseUrl, original.getInstanceId(), original.getHttpPort(), original.getContextPath());
        }
    }

    private ProductInstance changeBaseUrl(ProductInstance original, String newAddress) throws URISyntaxException {
        URI baseUri = URI.create(original.getBaseUrl());
        String updated = new URI(baseUri.getScheme(), baseUri.getUserInfo(), newAddress, baseUri.getPort(), baseUri.getPath(), baseUri.getQuery(), baseUri.getFragment()).toASCIIString();
        String baseUrlPropertyName = "baseurl." + original.getInstanceId();
        if (System.getProperty(baseUrlPropertyName) != null) {
            System.setProperty(baseUrlPropertyName, updated);
        }
        return new DefaultProductInstance(updated, original.getInstanceId(), original.getHttpPort(), original.getContextPath());
    }

    protected class ExtendedWebDriverModule
    extends WebDriverModule {
        public ExtendedWebDriverModule(TestedProduct<WebDriverTester> testedProduct) {
            super(testedProduct);
        }

        public void configure(Binder binder) {
            super.configure(binder);
            JavascriptExecutor javascriptExecutor = (JavascriptExecutor)WebDriverUtil.as((WebDriver)AbstractBitbucketTestedProduct.this.getTester().getDriver(), JavascriptExecutor.class);
            binder.bind(JavascriptExecutor.class).toInstance((Object)javascriptExecutor);
            binder.bind(SessionStorage.class).toInstance((Object)new JavascriptSessionStorage(javascriptExecutor));
            binder.bind(LocalStorage.class).toInstance((Object)new JavascriptLocalStorage(javascriptExecutor));
        }
    }
}

