/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.permissions;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.testing.PageElementMatchers;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openqa.selenium.By;

public class UserOrGroupSelector
extends AbstractElementPageObject {
    @Inject
    private PageElementFinder elementFinder;

    public UserOrGroupSelector(@Nonnull PageElement container) {
        super(container);
    }

    public TimedQuery<List<String>> getUsersOrGroups() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> ((List)this.getDropdownList().byDefaultTimeout()).stream().map(PageElement::getText).collect(Collectors.toList()));
    }

    public TimedCondition isPresent() {
        return this.dropdownSelector().timed().isPresent();
    }

    public void selectUserOrGroup(String userOrGroup) {
        this.dropdownSelector().find(By.tagName((String)"input")).type(new CharSequence[]{userOrGroup});
        ((List)Poller.waitUntil(this.getDropdownList(), (Matcher)CoreMatchers.hasItem((Matcher)PageElementMatchers.withText((String)userOrGroup)))).stream().filter(p -> userOrGroup.equals(p.getText())).findFirst().orElseThrow(() -> new AssertionError((Object)String.format("%s not found in the user or group selector drop-down", userOrGroup))).click();
    }

    private PageElement dropdownSelector() {
        return this.container.find(By.className((String)"user-and-group-selector"));
    }

    private TimedQuery<List<PageElement>> getDropdownList() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.elementFinder.findAll(By.cssSelector((String)".user-and-group-selector-option")));
    }
}

