/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.next;

import com.atlassian.bitbucket.pageobjects.element.next.FileContent;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import java.util.List;
import org.openqa.selenium.By;

public abstract class SourceFileContent
extends FileContent {
    public SourceFileContent(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public FileContent.Line getHighlightedLine(int index) {
        int totalLines = this.getTotalLines();
        float scrollPercentage = (float)index / (float)totalLines;
        PageElement fileContentsViewScroller = this.find(By.cssSelector((String)".file-contents-view div"));
        if (index >= 0 && index < totalLines) {
            fileContentsViewScroller.javascript().execute("arguments[0].scrollTo(0, Math.round(arguments[0].scrollHeight * " + scrollPercentage + "));", new Object[0]);
            List matches = (List)this.waitForSourceContainer(() -> this.findAll(By.cssSelector((String)(".file-viewer .diff-gutter[data-line-source=\"" + (index + 1) + "\"] + .diff-line")), FileContent.Line.class));
            return (FileContent.Line)((Object)matches.get(0));
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Total lines: " + totalLines);
    }

    public int getTotalLines() {
        this.waitUntilTextFileContentLoaded();
        PageElement totalLines = this.find(By.cssSelector((String)".file-contents .whole-file-contents"));
        return totalLines.getText().split("\n").length;
    }

    public abstract List<String> getSourceLines();
}

