/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.next;

import com.atlassian.bitbucket.test.next.TokenType;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.Comment;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;

public class FileContent
extends LegacyElementPageObject {
    @Inject
    protected PageElementFinder elementFinder;
    @Inject
    protected JavascriptExecutor javascriptExecutor;

    public FileContent(PageElement pageElement) {
        super(pageElement);
    }

    public FileContent(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public FileContent(By locator, WebDriverLocatable parent, TimeoutType timeoutType) {
        super(locator, parent, timeoutType);
    }

    public List<Comment> getComments() {
        this.waitUntilPageLoaded();
        return this.findAll(By.className((String)"comment"), Comment.class);
    }

    public void loadNextPage() {
        ElementUtils.scrollDocument((PageElement)this);
        this.waitUntilPageLoaded();
    }

    public void waitUntilFileContentLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)".file-contents,.message-content,.content-view,.binary-container,.diff-empty")).timed().isPresent());
    }

    public void waitUntilPageLoaded() {
        Poller.waitUntilTrue((String)"File Content is showing", (TimedQuery)this.elementFinder.find(By.className((String)"file-viewer")).timed().isVisible());
    }

    public void waitUntilTextFileContentLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)".file-contents .whole-file-contents")).timed().isPresent());
    }

    protected <T> T waitForSourceContainer(Supplier<T> supplier) {
        this.waitUntilPageLoaded();
        return (T)supplier.get();
    }

    public static class Line
    extends LegacyElementPageObject {
        public static final Function<PageElement, String> GET_TEXT = new Function<PageElement, String>(){

            public String apply(PageElement input) {
                return input.getText();
            }
        };

        public Line(PageElement pageElement) {
            super(pageElement);
        }

        public Line(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public Line(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        public String getSourceText() {
            return this.getText();
        }

        public List<String> getTokens(TokenType type) {
            return Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.findAll(By.cssSelector((String)type.getSelector())), GET_TEXT));
        }

        public boolean isAdd() {
            return this.hasClass("added-line");
        }

        public boolean isDelete() {
            return this.hasClass("removed-line");
        }
    }
}

