/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.codeinsights;

import com.atlassian.bitbucket.pageobjects.element.codeinsights.CodeInsightsOverviewAnnotation;
import com.atlassian.bitbucket.pageobjects.element.codeinsights.CodeInsightsOverviewDialog;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class CodeInsightsOverviewReport
extends AbstractElementPageObject {
    private final CodeInsightsOverviewDialog parent;
    @ElementBy(className="report-details-data")
    private PageElement customData;
    @ElementBy(className="report-description")
    private PageElement description;
    @ElementBy(className="report-annotations-table")
    private PageElement table;
    @ElementBy(cssSelector=".report-title > h5")
    private PageElement title;

    public CodeInsightsOverviewReport(@Nonnull PageElement container, @Nonnull CodeInsightsOverviewDialog parent) {
        super(container);
        this.parent = parent;
    }

    public List<CodeInsightsOverviewAnnotation> getAnnotations() {
        return this.table.find(By.tagName((String)"tbody")).findAll(By.className((String)"report-annotation-row")).stream().map(row -> (CodeInsightsOverviewAnnotation)this.pageBinder.bind(CodeInsightsOverviewAnnotation.class, new Object[]{row, this})).collect(Collectors.toList());
    }

    public Map<String, PageElement> getCustomData() {
        return this.customData.findAll(By.className((String)"data-cell")).stream().collect(Collectors.toMap(cell -> cell.find(By.tagName((String)"dt")).getText(), cell -> cell.find(By.tagName((String)"dd"))));
    }

    public TimedQuery<String> getDescription() {
        return this.description.timed().getText();
    }

    public String getProjectKey() {
        return this.parent.getProjectKey();
    }

    public long getPullRequestId() {
        return this.parent.getPullRequestId();
    }

    public String getSlug() {
        return this.parent.getSlug();
    }

    public TimedQuery<String> getTitle() {
        return this.title.timed().getText();
    }
}

