/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.element.SuggestionCard;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class RenderedMarkup
extends AbstractElementPageObject {
    private final PageElement renderedMarkup = this.find(By.className((String)"rendered-markup"));
    private final PageElement suggestionCard = this.find(By.className((String)"suggestion-card"));

    public RenderedMarkup(@Nonnull PageElement container) {
        super(container);
    }

    public PageElement getMarkupElement() {
        return this.renderedMarkup;
    }

    public List<SuggestionCard> getSuggestions() {
        return (List)this.container.findAll(By.className((String)"suggestion-card")).stream().map(ElementUtils.bind(this.pageBinder, SuggestionCard.class, new Object[0])).collect(MoreCollectors.toImmutableList());
    }

    public String getText() {
        return this.renderedMarkup.getText();
    }

    public String getTextAsHTML() {
        return ElementUtils.getHtml(this.renderedMarkup);
    }

    public TimedCondition hasSuggestionCard() {
        return this.suggestionCard.timed().isPresent();
    }
}

