/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.hooks;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.hooks.RepositoryHookRow;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class RepositoryHooksPage<T extends RepositoryHookRow>
extends BaseSidebarPage {
    private final Class<T> rowClass;
    private final String url;
    @ElementBy(cssSelector="#locked-settings-banner")
    private PageElement lockedSettingsBanner;

    public RepositoryHooksPage(String url, Class<T> rowClass) {
        this.url = url;
        this.rowClass = rowClass;
    }

    public RepositoryHooksPage clickSaveWithNewRestriction() {
        PageElement confirmRestrictChangesButton = this.elementFinder.find(By.cssSelector((String)"button.confirm-button"));
        Poller.waitUntilTrue((TimedQuery)confirmRestrictChangesButton.timed().isVisible());
        confirmRestrictChangesButton.click();
        return this;
    }

    @Override
    public void doWait() {
        super.doWait();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"footer-body")).timed().isPresent());
    }

    public PageElement getDescription() {
        return this.elementFinder.find(By.cssSelector((String)".aui-page-header + p"));
    }

    public T getHook(String hookName) {
        List hooks = this.getHooks();
        return (T)hooks.stream().filter(row -> hookName.equals(row.getName())).findFirst().orElseThrow(() -> {
            String availableHooks = String.join((CharSequence)", ", hooks.stream().map(RepositoryHookRow::getName).collect(Collectors.toList()));
            return new AssertionError((Object)("Could not find hook with name '" + hookName + "'. Available hooks: " + availableHooks));
        });
    }

    public List<T> getHooks(By selector) {
        return this.elementFinder.findAll(selector).stream().map(row -> (RepositoryHookRow)this.pageBinder.bind(this.rowClass, new Object[]{row, this})).collect(Collectors.toList());
    }

    public List<T> getHooks() {
        return this.getHooks(By.cssSelector((String)".hooks-table tbody tr"));
    }

    public Optional<PageElement> getProjectLink() {
        return this.getDescription().findAll(By.tagName((String)"a")).stream().filter(link -> "project settings".equals(link.getText())).findFirst();
    }

    public String getUrl() {
        return this.url;
    }

    public void loadMore() {
        this.elementFinder.find(By.cssSelector((String)".more-container button")).click();
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.cssSelector((String)"aui-spinner")).timed().isVisible());
    }

    public void verifyLockedSettingsBannerVisibility(boolean isVisible) {
        Poller.waitUntil((TimedQuery)this.lockedSettingsBanner.timed().isVisible(), (Matcher)Matchers.is((Object)isVisible));
    }
}

