/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.page.DataCenterHelpPage;
import com.atlassian.webdriver.bitbucket.page.LicenseEditPage;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import org.openqa.selenium.By;

public class LicensePage
extends BitbucketAdminPage {
    @ElementBy(id="license-edit")
    private PageElement editButton;
    @ElementBy(cssSelector=".aui-flag #get-started-dc")
    private PageElement getStartedDcLink;

    public LicensePage() {
    }

    public LicensePage(String webSudoPassword) {
        super(webSudoPassword);
    }

    @WaitUntil
    public void waitUntilVisible() {
        Poller.waitUntilTrue((TimedQuery)this.editButton.timed().isVisible());
    }

    public DataCenterHelpPage clickGetStartedDcLink() {
        this.getStartedDcLink.click();
        return (DataCenterHelpPage)this.pageBinder.bind(DataCenterHelpPage.class, new Object[0]);
    }

    public String getUrl() {
        return "/admin/license";
    }

    public String getServerId() {
        return this.elementFinder.find(By.id((String)"serverid")).getText();
    }

    public String getLicenseDescription() {
        return this.elementFinder.find(By.id((String)"license-description")).getText();
    }

    public String getLicensee() {
        return this.elementFinder.find(By.id((String)"license-owner")).getText();
    }

    public String getClustering() {
        return this.elementFinder.find(By.id((String)"license-clustered")).getText();
    }

    public String getSEN() {
        return this.elementFinder.find(By.id((String)"license-sen")).getText();
    }

    public String getExpiry() {
        return this.elementFinder.find(By.id((String)"license-expiry")).getText();
    }

    public String getMaintenanceExpiry() {
        return this.elementFinder.find(By.id((String)"license-maintenance-expiry")).getText();
    }

    public Integer getUserCount() {
        PageElement licensedUsers = this.elementFinder.find(By.id((String)"licensed-users"));
        if (licensedUsers.isPresent()) {
            String text = licensedUsers.getText();
            return text == null ? null : Integer.valueOf(text);
        }
        return null;
    }

    public String getUserLimit() {
        return this.elementFinder.find(By.id((String)"license-users")).getText();
    }

    public boolean isUpdated() {
        return this.getAuiSuccessMessages().stream().anyMatch(msg -> msg.contains("License change successful"));
    }

    public LicenseEditPage edit() {
        this.editButton.click();
        return (LicenseEditPage)this.pageBinder.bind(LicenseEditPage.class, new Object[0]);
    }

    public String getOverLimitError() {
        return this.getMessage(By.cssSelector((String)".aui-message-error.over-limit"));
    }

    public String getExpiredEvalError() {
        return this.getMessage(By.cssSelector((String)".aui-message-error.eval-expired"));
    }

    public String getEvalWarning() {
        return this.getMessage(By.cssSelector((String)".aui-message-warning.eval-notexpired"));
    }

    public String getMaintenanceExpiredError() {
        return this.getMessage(By.cssSelector((String)".aui-message-error.commercial-expired"));
    }

    private String getMessage(By selector) {
        PageElement element = this.elementFinder.find(selector, TimeoutType.UI_ACTION);
        return element.isPresent() ? element.getText() : null;
    }
}

