/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.bitbucket.commit.CommitListMergeFilter;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.CommitList;
import com.atlassian.webdriver.bitbucket.page.BranchLayoutPage;
import com.atlassian.webdriver.bitbucket.util.UrlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.By;

public class CommitListPage
extends BranchLayoutPage {
    private static final String COMMIT_ID_ATTRIBUTE = "data-commitid";
    private static final String COMMIT_ROW_SELECTOR = ".commit-row";
    private static final String COMMIT_TAG_ATTRIBUTE = "data-names";
    private static final String COMMIT_TAG_SELECTOR = ".tags-container .tag";
    @ElementBy(id="commit-graph-container")
    private PageElement commitGraphContainer;
    @ElementBy(id="commits-table", pageElementClass=CommitList.class)
    private CommitList commitList;
    @ElementBy(className="commits-table-spinner")
    private PageElement commitsSpinner;
    @ElementBy(id="show-merges-checkbox")
    private AuiCheckbox showMergesCheckbox;
    private final CommitListMergeFilter mergeFilter;
    private final String until;

    public CommitListPage(String projectKey, String repoSlug) {
        this(projectKey, repoSlug, null, null);
    }

    public CommitListPage(String projectKey, String repoSlug, CommitListMergeFilter mergeFilter) {
        this(projectKey, repoSlug, mergeFilter, null);
    }

    public CommitListPage(String projectKey, String repoSlug, String until) {
        this(projectKey, repoSlug, null, until);
    }

    public CommitListPage(String projectKey, String repoSlug, CommitListMergeFilter mergeFilter, String until) {
        super(projectKey, repoSlug);
        this.mergeFilter = mergeFilter;
        this.until = until;
    }

    public PageElement getCommitGraphContainer() {
        return this.commitGraphContainer;
    }

    public CommitList getCommitList() {
        return this.commitList;
    }

    public String getBranchNameFromUrl() {
        return UrlUtils.getReferenceNameFromUrlParameter("until", this.driver.getCurrentUrl());
    }

    public String getUrl() {
        String queryParams = "?" + com.atlassian.bitbucket.util.UrlUtils.buildQueryParams((Object[])new Object[]{"until", this.until == null ? null : this.until, "merges", this.mergeFilter == null ? null : this.mergeFilter.name()});
        return "/projects/" + this.projectKey + "/repos/" + this.slug + "/commits" + queryParams;
    }

    public List<String> getTagsFor(String commitId) {
        Poller.waitUntilTrue((TimedQuery)this.commitList.find(By.cssSelector((String)COMMIT_TAG_SELECTOR)).timed().isVisible());
        ArrayList<String> tags = new ArrayList<String>();
        this.getRowForCommit(commitId).ifPresent(row -> {
            for (PageElement tagSelector : row.findAll(By.cssSelector((String)COMMIT_TAG_SELECTOR))) {
                String attr = tagSelector.getAttribute(COMMIT_TAG_ATTRIBUTE);
                if (attr == null) continue;
                tags.addAll(Arrays.asList(attr.split(":")));
            }
        });
        return tags;
    }

    public boolean isCheckboxEnabled() {
        return this.showMergesCheckbox.isEnabled();
    }

    public CommitListPage toggleShowMergesCheckbox() {
        this.showMergesCheckbox.click();
        return this;
    }

    public CommitListPage waitUntilCommitsTableLoaded() {
        Poller.waitUntilFalse((TimedQuery)this.commitsSpinner.timed().isVisible());
        return this;
    }

    private Optional<PageElement> getRowForCommit(String commitId) {
        List elements = this.getCommitList().findAll(By.cssSelector((String)COMMIT_ROW_SELECTOR));
        for (PageElement row : elements) {
            String attr = row.getAttribute(COMMIT_ID_ATTRIBUTE);
            if (attr == null || !attr.contains(commitId)) continue;
            return Optional.of(row);
        }
        return Optional.empty();
    }
}

