/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.test.BuildStatusTestHelper;
import com.atlassian.bitbucket.test.TestContext;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.SearchableSelector;
import com.atlassian.webdriver.bitbucket.element.SimpleSelect;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.FileBrowserPage;
import org.openqa.selenium.By;

public class BranchCreationPage
extends BitbucketPage {
    @ElementBy(id="repository-selector")
    private PageElement repositorySelectorTriggerElem;
    @ElementBy(id="branch-type")
    private PageElement branchTypeTriggerElem;
    @ElementBy(id="branch-type-menu")
    private PageElement branchTypeDropdownElem;
    @ElementBy(id="branch-from-selector")
    private PageElement branchFromTriggerElem;
    @ElementBy(id="branch-name")
    private PageElement branchNameElem;
    @ElementBy(id="create-branch-submit")
    private PageElement createBranchSubmit;
    @ElementBy(cssSelector=".buttons-container .submit-spinner")
    private PageElement createBranchSpinner;
    @ElementBy(className="jira-issue-key")
    private PageElement jiraIssueKey;
    private final String urlParams;

    public BranchCreationPage() {
        this("");
    }

    public BranchCreationPage(String urlParams) {
        this.urlParams = urlParams;
    }

    public String getUrl() {
        return "/plugins/servlet/create-branch?" + this.urlParams;
    }

    public String getBranchType() {
        return this.getBranchTypeSelector().getSelection();
    }

    public String getBranchPrefix() {
        PageElement branchPrefix = this.elementFinder.find(By.className((String)"branch-name-prefix"));
        return branchPrefix.isPresent() ? branchPrefix.getText() : "";
    }

    public TimedQuery<String> getPreviewSourceBranchName() {
        return this.elementFinder.find(By.cssSelector((String)".branch-diagram-create .source-ref .name")).timed().getText();
    }

    public TimedQuery<String> getPreviewTargetBranchName() {
        return this.elementFinder.find(By.cssSelector((String)".branch-diagram-create .target-ref .name")).timed().getText();
    }

    public String getIssueKey() {
        return this.jiraIssueKey.getText();
    }

    public BranchCreationPage setRepository(String projectName, String repoName) {
        this.getRepositorySelector().open().selectItemByName(projectName + "/" + repoName);
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.cssSelector((String)".repository-spinner > .spinner")).timed().isPresent());
        return this;
    }

    public BranchCreationPage setBranchType(String branchType) {
        this.getBranchTypeSelector().setSelect(branchType);
        return this;
    }

    public BranchCreationPage setBranchFrom(String branchId) {
        this.getBranchFromSelector().open().selectItemById(branchId);
        return this;
    }

    public BranchCreationPage setBranchFromOfTypeTag(String tagId) {
        this.getBranchFromSelector().open().selectTags().selectItemByName(tagId);
        return this;
    }

    public BranchCreationPage setBranchName(String branchName) {
        this.branchNameElem.clear();
        this.branchNameElem.type(new CharSequence[]{branchName});
        return this;
    }

    public FileBrowserPage createBranch(String projectKey, String repoSlug) {
        return this.createBranch(projectKey, repoSlug, null);
    }

    public FileBrowserPage createBranch(final String projectKey, final String repoSlug, final TestContext context) {
        this.waitForPageLoad(new Runnable(){

            @Override
            public void run() {
                Poller.waitUntilTrue((TimedQuery)BranchCreationPage.this.createBranchSubmit.timed().isEnabled());
                if (context != null) {
                    context.addCreatedBranch(projectKey, repoSlug, (String)BranchCreationPage.this.getPreviewTargetBranchName().now());
                }
                BranchCreationPage.this.createBranchSubmit.click();
                Poller.waitUntilFalse((TimedQuery)BranchCreationPage.this.createBranchSpinner.timed().isVisible());
            }
        });
        return (FileBrowserPage)this.pageBinder.bind(FileBrowserPage.class, new Object[]{projectKey, repoSlug});
    }

    public boolean hasEmptyRepositoryError() {
        return this.elementFinder.find(By.cssSelector((String)".repository-field .error")).isPresent();
    }

    public boolean hasBranchTypes() {
        return this.branchTypeTriggerElem.isVisible();
    }

    public boolean hasNoWriteAccess() {
        return this.elementFinder.find(By.className((String)"no-write-access")).isPresent();
    }

    public SearchableSelector getRepositorySelector() {
        return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.repositorySelectorTriggerElem, By.id((String)"repository-selector-dialog")});
    }

    public SimpleSelect getBranchTypeSelector() {
        return (SimpleSelect)this.pageBinder.bind(SimpleSelect.class, new Object[]{this.branchTypeTriggerElem, this.branchTypeDropdownElem});
    }

    public SearchableSelector getBranchFromSelector() {
        return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.branchFromTriggerElem, By.id((String)"branch-from-selector-dialog")});
    }

    public TimedQuery<Boolean> hasBuildStatus() {
        PageElement buildIcon = this.elementFinder.find(By.cssSelector((String)"#branch-from-selector + .build-icon"));
        return buildIcon.timed().isPresent();
    }

    public BuildStatusTestHelper.State getBuildStatus() {
        PageElement buildIcon = this.elementFinder.find(By.cssSelector((String)"#branch-from-selector + .build-icon"));
        Poller.waitUntilTrue((TimedQuery)buildIcon.timed().isPresent());
        if (buildIcon.hasClass("failed-build-icon")) {
            return BuildStatusTestHelper.State.FAILED;
        }
        if (buildIcon.hasClass("successful-build-icon")) {
            return BuildStatusTestHelper.State.SUCCESSFUL;
        }
        if (buildIcon.hasClass("inprogress-build-icon")) {
            return BuildStatusTestHelper.State.INPROGRESS;
        }
        if (buildIcon.hasClass("unknown-build-icon")) {
            return BuildStatusTestHelper.State.UNKNOWN;
        }
        if (buildIcon.hasClass("cancelled-build-icon")) {
            return BuildStatusTestHelper.State.CANCELLED;
        }
        return null;
    }

    public static class BranchParamsBuilder {
        private Integer repoId;
        private String branchFrom;
        private String branchType;
        private String issueKey;
        private String issueSummary;
        private String issueType;

        public BranchParamsBuilder repo(int repoId) {
            this.repoId = repoId;
            return this;
        }

        public BranchParamsBuilder branchFrom(String branchFrom) {
            this.branchFrom = branchFrom;
            return this;
        }

        public BranchParamsBuilder branchType(String branchType) {
            this.branchType = branchType;
            return this;
        }

        public BranchParamsBuilder issueKey(String issueKey) {
            this.issueKey = issueKey;
            return this;
        }

        public BranchParamsBuilder issueSummary(String issueSummary) {
            this.issueSummary = issueSummary;
            return this;
        }

        public BranchParamsBuilder issueType(String issueType) {
            this.issueType = issueType;
            return this;
        }

        public String build() {
            StringBuilder builder = new StringBuilder();
            if (this.repoId != null) {
                builder.append("&repoId=").append(UrlUtils.encodeURL((String)Integer.toString(this.repoId)));
            }
            if (this.branchFrom != null) {
                builder.append("&branchFrom=").append(UrlUtils.encodeURL((String)this.branchFrom));
            }
            if (this.branchType != null) {
                builder.append("&branchType=").append(UrlUtils.encodeURL((String)this.branchType));
            }
            if (this.issueKey != null) {
                builder.append("&issueKey=").append(UrlUtils.encodeURL((String)this.issueKey));
            }
            if (this.issueSummary != null) {
                builder.append("&issueSummary=").append(UrlUtils.encodeURL((String)this.issueSummary));
            }
            if (this.issueType != null) {
                builder.append("&issueType=").append(UrlUtils.encodeURL((String)this.issueType));
            }
            if (builder.length() > 0 && builder.charAt(0) == '&') {
                builder.deleteCharAt(0);
            }
            return builder.toString();
        }
    }
}

