/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page.next;

import com.atlassian.bitbucket.pageobjects.page.next.FileContentPage;
import com.atlassian.bitbucket.pageobjects.page.next.FileLayoutPage;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.next.SideBySideDiffFileContent;
import com.atlassian.webdriver.bitbucket.util.KeyboardShortcuts;
import org.junit.Assert;
import org.openqa.selenium.By;

public class FileSideBySideDiffPage
extends FileContentPage<SideBySideDiffFileContent> {
    @ElementBy(className="file-content", pageElementClass=SideBySideDiffFileContent.class)
    protected SideBySideDiffFileContent diffContent;
    @ElementBy(className="expand-context-button")
    protected PageElement expandContextButton;

    public FileSideBySideDiffPage(String projectKey, String repoSlug, String path) {
        super(projectKey, repoSlug, path);
    }

    public FileSideBySideDiffPage(String projectKey, String repoSlug, String path, FileLayoutPage.RevisionSpecifier revisionSpecifier) {
        super(projectKey, repoSlug, path, revisionSpecifier);
    }

    @Override
    public SideBySideDiffFileContent getFileContent() {
        return this.diffContent;
    }

    @Override
    protected String getPathComponent() {
        return "diff";
    }

    public FileSideBySideDiffPage loadUntilRevision(String revision) {
        return this.loadRevision(revision, FileSideBySideDiffPage.class);
    }

    public void moveToNextChange(boolean expectMovement) {
        this.navigateDiff(expectMovement, () -> KeyboardShortcuts.moveToNextSecondary(this.body));
    }

    public void moveToPreviousChange(boolean expectMovement) {
        this.navigateDiff(expectMovement, () -> KeyboardShortcuts.moveToPreviousSecondary(this.body));
    }

    private void navigateDiff(boolean expectMovement, Runnable doNavigation) {
        if (expectMovement) {
            this.waitUntilPresent(this.getFileContent().find(By.className((String)"active-diff-line")), doNavigation);
        } else {
            doNavigation.run();
        }
    }

    private void waitUntilPresent(PageElement element, Runnable operation) {
        operation.run();
        Assert.assertTrue((boolean)element.isPresent());
    }
}

