/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page.crowd;

import com.atlassian.bitbucket.pageobjects.page.crowd.ConfigureLdapDirectoryPage;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import org.openqa.selenium.By;

public class UserDirectoriesPage
extends BitbucketAdminPage {
    private static final String DIRECTORY_ID_PREFIX = "directory-";

    public ConfigureLdapDirectoryPage addNewLdapDirectory() {
        return (ConfigureLdapDirectoryPage)this.pageBinder.navigateToAndBind(ConfigureLdapDirectoryPage.class, new Object[0]);
    }

    public void disable(int directoryId) {
        this.runDirectoryAction(directoryId, "disable");
    }

    public void remove(int directoryId) {
        this.runDirectoryAction(directoryId, "remove");
    }

    public void waitForSuccessfulSync(int directoryId) {
        PageElement directoryRow = this.getDirectoryRow(directoryId);
        directoryRow.find(By.className((String)"sync")).select().click();
        TimedQuery isSucessful = Queries.forSupplier((Timeouts)this.timeouts, () -> {
            PageElement syncState = directoryRow.find(By.className((String)"sync-state"));
            return syncState.getText().contains("Full synchronisation completed successfully");
        });
        Poller.waitUntilTrue((TimedQuery)isSucessful);
    }

    private PageElement getDirectoryRow(int directoryId) {
        return this.elementFinder.find(By.id((String)(DIRECTORY_ID_PREFIX + directoryId)));
    }

    private void runDirectoryAction(int directoryId, String action) {
        PageElement directoryRow = this.getDirectoryRow(directoryId);
        PageElement button = directoryRow.find(By.className((String)action));
        Poller.waitUntilTrue((TimedQuery)button.timed().isVisible());
        button.click();
    }

    public String getUrl() {
        return "/plugins/servlet/embedded-crowd/directories/list";
    }
}

