/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.tasks;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.TimedUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class PullRequestTaskListDialog
extends AbstractElementPageObject {
    private final PageElement closeButton = this.find(By.cssSelector((String)"[data-testid='close-modal-button']"));
    private final PageElement openTaskCount = this.find(By.className((String)"tasks-tab-count"));
    private final PageElement openTasksTab = this.find(By.cssSelector((String)"[data-testid='open-tasks-tab']"));
    private final PageElement resolvedTasksTab = this.find(By.cssSelector((String)"[data-testid='resolved-tasks-tab']"));
    private final PageElement taskList = this.find(By.className((String)"tasks-list"));
    private final PageElement taskListSpinner = this.find(By.className((String)"tasks-list-spinner"));

    public PullRequestTaskListDialog(@Nonnull PageElementFinder elementFinder) {
        super(elementFinder.find(By.cssSelector((String)"[data-testid='task-overview-modal']")));
        Poller.waitUntilTrue((TimedQuery)this.container.timed().isVisible());
    }

    public PullRequestTaskListDialog clickOpenTab() {
        this.openTasksTab.click();
        return this;
    }

    public PullRequestTaskListDialog clickResolvedTab() {
        this.resolvedTasksTab.click();
        return this;
    }

    public void close() {
        this.closeButton.click();
        Poller.waitUntilFalse((TimedQuery)this.container.timed().isPresent());
    }

    public TimedQuery<Integer> getOpenTaskCount() {
        return TimedUtils.toMappable(this.openTaskCount.timed().getText()).map(Integer::parseInt);
    }

    public List<DialogTask> getTaskList() {
        Poller.waitUntilFalse((TimedQuery)this.taskListSpinner.timed().isPresent());
        return this.taskList.findAll(By.className((String)"task")).stream().map(DialogTask::new).collect(Collectors.toList());
    }

    public TimedCondition isVisible() {
        return this.container.timed().isVisible();
    }

    public static class DialogTask
    extends AbstractElementPageObject {
        private final PageElement checkbox = this.find(By.cssSelector((String)".comment-task .comment-task-checkbox"));
        private final PageElement text = this.find(By.cssSelector((String)".comment-task .comment-task-body"));
        private final PageElement viewLink = this.find(By.cssSelector((String)".task-footer > .task-footer-primary > a"));

        public DialogTask(@Nonnull PageElement parentElement) {
            super(parentElement);
        }

        public void clickViewLink() {
            this.viewLink.withTimeout(TimeoutType.UI_ACTION).click();
        }

        public TimedQuery<String> getText() {
            return this.text.timed().getText();
        }

        public DialogTask toggleResolved() {
            this.checkbox.click();
            return this;
        }
    }
}

