/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.reviewmode;

import com.atlassian.bitbucket.pageobjects.element.CodeMirrorEditor;
import com.atlassian.bitbucket.pageobjects.element.ConfirmDialog;
import com.atlassian.bitbucket.pageobjects.element.reviewmode.ReviewCommentsDialog;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class CompleteReviewDialog
extends AbstractElementPageObject {
    private final PageElement approvedRadioButton = this.find(By.cssSelector((String)"[data-testid='radio-button-approved--radio-input']"));
    private final PageElement completeReviewCommentForm = this.find(By.className((String)"CodeMirror-code"));
    private final PageElement discardReviewButton = this.find(By.cssSelector((String)"[data-testid='complete-review-delete-all-button'"));
    private final PageElement publishReviewButton = this.find(By.cssSelector((String)"[data-testid='complete-review-publish-button']"));
    private final PageElement pullRequestStatusSelection = this.find(By.className((String)"review-mode-status-selection"));
    private final PageElement reviewCommentsButton = this.find(By.cssSelector((String)"[data-testid='complete-review-review-comments-dialog-link']"));
    private final PageElement selectedStatus = this.find(By.cssSelector((String)".review-mode-status-selection input:checked"));
    @ElementBy(cssSelector="[data-testid='delete-review-modal']")
    private PageElement discardReviewDialog;
    @Inject
    private PageElementFinder elementFinder;

    public CompleteReviewDialog(@Nonnull PageElementFinder elementFinder) {
        super(elementFinder.find(By.className((String)"complete-review-dialog")));
        Poller.waitUntilTrue((TimedQuery)this.container.timed().isVisible());
    }

    public void discardReview() {
        this.discardReviewButton.click();
        ConfirmDialog confirmDiscardDialog = (ConfirmDialog)this.pageBinder.bind(ConfirmDialog.class, new Object[]{this.discardReviewDialog});
        confirmDiscardDialog.clickButton("Delete");
    }

    public String getCompleteReviewCommentText() {
        return this.completeReviewCommentForm.getText();
    }

    public String getSelectedStatus() {
        return this.selectedStatus.getValue();
    }

    public TimedCondition hasPullRequestStatusSection() {
        return this.pullRequestStatusSelection.timed().isPresent();
    }

    public ReviewCommentsDialog openReviewCommentsDialog() {
        this.reviewCommentsButton.withTimeout(TimeoutType.UI_ACTION).click();
        return (ReviewCommentsDialog)this.pageBinder.bind(ReviewCommentsDialog.class, new Object[]{this.elementFinder});
    }

    public CompleteReviewDialog publishReview() {
        this.publishReviewButton.withTimeout(TimeoutType.UI_ACTION).click();
        return this;
    }

    public CompleteReviewDialog setCompleteReviewComment(String msg) {
        this.completeReviewCommentForm.withTimeout(TimeoutType.UI_ACTION).click();
        CodeMirrorEditor editor = (CodeMirrorEditor)this.pageBinder.bind(CodeMirrorEditor.class, new Object[]{this.container});
        editor.setText(msg);
        return this;
    }

    public CompleteReviewDialog setPullRequestApproved() {
        this.approvedRadioButton.withTimeout(TimeoutType.PAGE_LOAD).click();
        return this;
    }
}

