/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.next;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementActions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.utils.by.ByDataAttribute;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class SearchableSelectorDialog {
    @Inject
    protected PageElementActions actions;
    private final PageElement dialog;

    public SearchableSelectorDialog(PageElement dialog) {
        this.dialog = Objects.requireNonNull(dialog, "dialog");
    }

    public SearchableSelectorDialog filterBy(String filterText) {
        PageElement filterInput = this.dialog.find(By.className((String)"filterable-tabs__input"));
        Preconditions.checkState((boolean)filterInput.isPresent(), (Object)"Searchable selector is not filterable");
        filterInput.type(new CharSequence[]{filterText});
        return this;
    }

    public PageElement getResultsList() {
        String resultListSelector = ".filterable-tabs__menu";
        return this.dialog.find(By.cssSelector((String)resultListSelector));
    }

    public TimedCondition isLoadingPage() {
        return this.dialog.find(By.className((String)"spinner-wrapper")).timed().isVisible();
    }

    public TimedCondition isOpen() {
        return this.dialog.timed().isVisible();
    }

    public void selectItemById(String dataId) {
        PageElement item = this.getResultsList().find(ByDataAttribute.byData((String)"test-value", (String)dataId));
        this.selectDropdownElement(item);
        Poller.waitUntilFalse((TimedQuery)this.dialog.timed().isVisible());
    }

    public void selectItemByName(String itemName) {
        PageElement pageElement = this.getResultsList().find(ByDataAttribute.byData((String)"test-label", (String)itemName));
        this.selectDropdownElement(pageElement);
        Poller.waitUntilFalse((TimedQuery)this.dialog.timed().isVisible());
    }

    public SearchableSelectorDialog selectTags() {
        return this.selectTab("filterable-tabs-1");
    }

    private void selectDropdownElement(PageElement element) {
        ElementUtils.scrollIntoView(element);
        this.actions.moveToElement(element).perform();
        element.click();
    }

    private SearchableSelectorDialog selectTab(String tabId) {
        PageElement tab = this.dialog.find(By.id((String)tabId)).click();
        Poller.waitUntilTrue((TimedQuery)tab.timed().hasAttribute("aria-selected", "true"));
        return this;
    }
}

