/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.codeinsights;

import com.atlassian.bitbucket.codeinsights.report.InsightResult;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.TimedUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class CodeInsightsOverviewReportMenuItem
extends AbstractElementPageObject {
    private PageElement logo = this.find(By.tagName((String)"img"));
    private PageElement result = this.find(By.cssSelector((String)":last-child"));
    private PageElement title = this.find(By.className((String)"report-item-text"));

    public CodeInsightsOverviewReportMenuItem(@Nonnull PageElement container) {
        super(container);
    }

    public TimedQuery<String> getLogoUrl() {
        return this.logo.timed().getAttribute("src");
    }

    public TimedQuery<String> getResult() {
        return TimedUtils.toMappable(this.result.timed().getText()).map(text -> Arrays.stream(InsightResult.values()).filter(it -> text.toUpperCase(Locale.US).startsWith(it.name())).map(Enum::toString).findFirst().orElse(null));
    }

    public TimedQuery<String> getTitle() {
        return this.title.timed().getText();
    }

    public TimedQuery<Boolean> hasResult() {
        return TimedUtils.toMappable(this.getResult()).map(Objects::nonNull);
    }

    public TimedQuery<Boolean> usingCustomLogo() {
        return this.logo.timed().isPresent();
    }
}

