/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.element.codeinsights.FileReportsDialog;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class DiffToolbar
extends AbstractElementPageObject {
    private final PageElement addFileComment = this.find(By.cssSelector((String)"[data-testid='diff-comment-trigger']"));
    private final PageElement blameButton = this.find(By.cssSelector((String)"[data-testid='blame-button']"));
    private final PageElement changeTypeLozenge = this.find(By.cssSelector((String)"[data-testid='change-lozenge']"));
    private final PageElement copyFilePathButton = this.find(By.className((String)"copy-file-path-button"));
    private final PageElement diffOptionsDropdownTrigger = this.find(By.cssSelector((String)"[data-testid='diff-options-dropdown-trigger']"));
    private final PageElement fileName = this.find(By.className((String)"file-breadcrumbs-segment-highlighted"));
    private final PageElement filePath = this.find(By.className((String)"file-breadcrumbs"));
    private final PageElement fileReportsButton = this.find(By.cssSelector((String)"[data-testid='file-reports-button']"));
    private final PageElement fileReportsDialog = this.find(By.className((String)"file-reports-dialog"));
    private final PageElement showAnnotationsRadio = this.find(By.id((String)"showAnnotations"));
    private final PageElement showCodeCoverageRadio = this.find(By.id((String)"showCoverage"));
    private final PageElement viewSourceLink = this.find(By.cssSelector((String)"[data-testid='diff-view-source-button']"));
    @Inject
    private PageElementFinder elementFinder;

    public DiffToolbar(@Nonnull PageElement container) {
        super(container);
    }

    public void clickAddFileComment() {
        this.addFileComment.click();
    }

    public void clickCopyFilePathButton() {
        this.copyFilePathButton.click();
    }

    public PageElement getBlameButton() {
        return this.blameButton;
    }

    public ChangeType getChangeType() {
        String changeTypeStr = this.changeTypeLozenge.getText().toUpperCase();
        return ChangeType.valueOf(changeTypeStr);
    }

    public String getFileName() {
        return this.fileName.getText();
    }

    public String getFilePath() {
        return this.filePath.getText();
    }

    public String getFileReportsButtonLabel() {
        Poller.waitUntilTrue((TimedQuery)this.fileReportsButton.timed().isVisible());
        return this.fileReportsButton.getAttribute("aria-label");
    }

    public String getSourceLinkUrl() {
        return this.viewSourceLink.getAttribute("href");
    }

    public boolean hasCodeInsightsOptions() {
        this.openDiffOptions();
        boolean hasCodeInsightsOptions = this.showAnnotationsRadio.isPresent() || this.showCodeCoverageRadio.isPresent();
        this.closeDiffOptions();
        return hasCodeInsightsOptions;
    }

    public boolean hasCommentOptions() {
        this.openDiffOptions();
        PageElement showCommentsAndTasksRadio = this.getShowCommentsAndTasksRadio();
        boolean hasCommentOptions = showCommentsAndTasksRadio.isPresent();
        this.closeDiffOptions();
        return hasCommentOptions;
    }

    public boolean hasSourceView() {
        return (Boolean)this.viewSourceLink.timed().isVisible().byDefaultTimeout();
    }

    public FileReportsDialog openFileReportsDialog() {
        Poller.waitUntilTrue((TimedQuery)this.fileReportsButton.timed().isVisible());
        this.fileReportsButton.click();
        return (FileReportsDialog)this.pageBinder.bind(FileReportsDialog.class, new Object[]{this.fileReportsDialog});
    }

    public void toggleHideComments() {
        this.openDiffOptions();
        PageElement showCommentsAndTasksRadio = this.getShowCommentsAndTasksRadio();
        Poller.waitUntilTrue((TimedQuery)showCommentsAndTasksRadio.timed().isVisible());
        showCommentsAndTasksRadio.click();
        this.closeDiffOptions();
    }

    public void viewSideBySideDiff() {
        this.openDiffOptions();
        PageElement sideBySideDiffRadio = this.elementFinder.find(By.id((String)"diffMode-SIDE_BY_SIDE"));
        sideBySideDiffRadio.click();
        this.closeDiffOptions();
    }

    public void viewUnifiedDiff() {
        this.openDiffOptions();
        PageElement unifiedDiffRadio = this.elementFinder.find(By.id((String)"diffMode-UNIFIED"));
        unifiedDiffRadio.click();
        this.closeDiffOptions();
    }

    private void closeDiffOptions() {
        this.diffOptionsDropdownTrigger.click();
        PageElement diffOptionsDropdownContent = this.getDiffOptionsDropdownContent();
        Poller.waitUntilFalse((TimedQuery)diffOptionsDropdownContent.timed().isVisible());
    }

    private PageElement getDiffOptionsDropdownContent() {
        return this.elementFinder.find(By.className((String)"diff-options-dropdown-content"));
    }

    private PageElement getShowCommentsAndTasksRadio() {
        return this.elementFinder.find(By.id((String)"showComments"));
    }

    private void openDiffOptions() {
        this.diffOptionsDropdownTrigger.click();
        PageElement diffOptionsDropdownContent = this.getDiffOptionsDropdownContent();
        Poller.waitUntilTrue((TimedQuery)diffOptionsDropdownContent.timed().isVisible());
    }

    public static enum ChangeType {
        ADDED,
        COPIED,
        DELETED,
        MODIFIED,
        MOVED,
        RENAMED;

    }
}

