/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.webhook;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.webhook.BaseWebhookPage;
import com.atlassian.webdriver.bitbucket.page.webhook.RepositoryWebhookCreatePage;
import com.atlassian.webdriver.bitbucket.page.webhook.RepositoryWebhookRow;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;

public class RepositoryWebhookPage
extends BaseWebhookPage {
    private final String projectKey;
    private final String repoSlug;
    @ElementBy(cssSelector="#webhooks-container .aui-button.action-button, #webhooks-container .aui-button-primary")
    private PageElement createWebhookButton;
    @ElementBy(className="webhooks-empty-message")
    private PageElement emptyMessage;

    public RepositoryWebhookPage(String projectKey, String repoSlug) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
    }

    public String getUrl() {
        return String.format("/plugins/servlet/webhooks/projects/%s/repos/%s/", this.projectKey, this.repoSlug);
    }

    public RepositoryWebhookCreatePage createWebhook() {
        this.createWebhookButton.click();
        return (RepositoryWebhookCreatePage)this.pageBinder.bind(RepositoryWebhookCreatePage.class, new Object[]{this.projectKey, this.repoSlug});
    }

    public void delete(RepositoryWebhookRow webhook) {
        webhook.delete();
        PageElement deleteDialog = this.elementFinder.find(By.cssSelector((String)"[data-testid='webhook-delete-modal']"));
        Poller.waitUntilTrue((TimedQuery)deleteDialog.timed().isVisible());
        PageElement deleteButton = deleteDialog.find(By.className((String)"webhook-delete-dialog-delete-button"));
        Poller.waitUntilTrue((TimedQuery)deleteButton.timed().isVisible());
        deleteButton.click();
    }

    public List<RepositoryWebhookRow> getWebhooks() {
        return this.webhooksTable.findAll(By.tagName((String)"tr")).stream().map(tr -> (RepositoryWebhookRow)this.pageBinder.bind(RepositoryWebhookRow.class, new Object[]{tr})).collect(Collectors.toList());
    }

    public TimedCondition isEmptyState() {
        return this.emptyMessage.timed().isVisible();
    }
}

