/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.webhook;

import com.atlassian.bitbucket.pageobjects.element.ReactSelect;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.webhook.BaseWebhookCreatePage;
import com.atlassian.webdriver.bitbucket.page.webhook.ProjectWebhookCreateResult;
import com.atlassian.webdriver.bitbucket.page.webhook.ProjectWebhookPage;

public class ProjectWebhookCreatePage
extends BaseWebhookCreatePage {
    private final String projectKey;

    public ProjectWebhookCreatePage(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getUrl() {
        return String.format("/plugins/servlet/webhooks/projects/%s/create", this.projectKey);
    }

    public ProjectWebhookPage clickCancel() {
        this.cancelLink.click();
        return (ProjectWebhookPage)this.pageBinder.bind(ProjectWebhookPage.class, new Object[]{this.projectKey});
    }

    public ProjectWebhookCreateResult clickConfirm() {
        this.confirmButton.click();
        return (ProjectWebhookCreateResult)this.pageBinder.bind(ProjectWebhookCreateResult.class, new Object[]{this.projectKey});
    }

    public ProjectWebhookCreatePage setAuthenticationMethod(String authenticationMethod) {
        ReactSelect keySelect = (ReactSelect)this.pageBinder.bind(ReactSelect.class, new Object[]{this.container, "authentication-select"});
        keySelect.selectOptionByPartialName(authenticationMethod);
        return this;
    }

    public ProjectWebhookCreatePage setName(String name) {
        Poller.waitUntilTrue((TimedQuery)this.nameInput.timed().isVisible());
        this.nameInput.clear().type(new CharSequence[]{name});
        return this;
    }

    public ProjectWebhookCreatePage setPassword(String password) {
        Poller.waitUntilTrue((TimedQuery)this.passwordInput.timed().isVisible());
        this.passwordInput.clear().type(new CharSequence[]{password});
        return this;
    }

    public ProjectWebhookCreatePage setSecret(String name) {
        Poller.waitUntilTrue((TimedQuery)this.secretInput.timed().isVisible());
        this.secretInput.clear().type(new CharSequence[]{name});
        return this;
    }

    public ProjectWebhookCreatePage setUrl(String url) {
        Poller.waitUntilTrue((TimedQuery)this.urlInput.timed().isVisible());
        this.urlInput.clear().type(new CharSequence[]{url});
        return this;
    }

    public ProjectWebhookCreatePage setUsername(String username) {
        Poller.waitUntilTrue((TimedQuery)this.usernameInput.timed().isVisible());
        this.usernameInput.clear().type(new CharSequence[]{username});
        return this;
    }
}

