/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import org.openqa.selenium.By;

public class LoggingAndProfilingPage
extends BitbucketAdminPage {
    @ElementBy(id="enableDebugLogging")
    private AuiCheckbox enableDebugLogging;
    @ElementBy(id="enableProfiling")
    private AuiCheckbox enableProfiling;
    @ElementBy(id="submit")
    private PageElement submit;

    public LoggingAndProfilingPage checkEnableDebugLogging(boolean checked) {
        this.check(this.enableDebugLogging, checked);
        return this;
    }

    public LoggingAndProfilingPage checkEnableProfiling(boolean checked) {
        this.check(this.enableProfiling, checked);
        return this;
    }

    public String getErrorMessage() {
        PageElement errorMessage = this.elementFinder.find(By.cssSelector((String)"#content h2"));
        Poller.waitUntilTrue((TimedQuery)errorMessage.timed().isVisible());
        return errorMessage.getText();
    }

    public String getUrl() {
        return "/admin/logging";
    }

    public boolean isDebuggingEnabled() {
        return this.enableDebugLogging.isSelected();
    }

    public boolean isProfilingEnabled() {
        return this.enableProfiling.isSelected();
    }

    public LoggingAndProfilingPage submit() {
        this.submit.click();
        return (LoggingAndProfilingPage)this.pageBinder.bind(LoggingAndProfilingPage.class, new Object[0]);
    }

    private void check(AuiCheckbox checkbox, boolean checked) {
        if (checkbox.isSelected() != checked) {
            checkbox.click();
        }
    }
}

