/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.ProjectSidebarNav;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import com.atlassian.webdriver.bitbucket.page.ProjectEditSettingsPage;
import com.atlassian.webdriver.bitbucket.page.ProjectOverviewPage;
import org.openqa.selenium.By;

public abstract class BaseProjectPage
extends BaseSidebarPage {
    private final String key;
    @ElementBy(cssSelector="#content > .aui-sidebar", pageElementClass=ProjectSidebarNav.class)
    private ProjectSidebarNav sidebarNav;

    public BaseProjectPage(String key) {
        this.key = key;
    }

    @Override
    public void doWait() {
        super.doWait();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"footer-body")).timed().isPresent());
    }

    public String getProjectKey() {
        return this.key;
    }

    public String getProjectName() {
        return this.elementFinder.find(By.cssSelector((String)"#content")).getAttribute("data-projectname");
    }

    public ProjectSidebarNav getSidebarNav() {
        return this.sidebarNav;
    }

    public ProjectEditSettingsPage goToEditSettingsPage() {
        this.sidebarNav.clickSettingsItem();
        return (ProjectEditSettingsPage)this.pageBinder.bind(ProjectEditSettingsPage.class, new Object[]{this.key});
    }

    public ProjectOverviewPage goToOverviewPage() {
        this.sidebarNav.clickRepositoriesItem();
        return (ProjectOverviewPage)this.pageBinder.bind(ProjectOverviewPage.class, new Object[]{this.key});
    }
}

