/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.refmatcher;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.refmatcher.RefMatcherEntry;
import com.atlassian.webdriver.bitbucket.element.refmatcher.RefMatcherEntryType;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class RefMatcherListDisplay
extends AbstractElementPageObject {
    private final PageElement branchIcon;
    private final PageElement inactiveLozenge;
    private final PageElement pattern = this.find(By.className((String)"pattern"));
    private final PageElement refMatch = this.find(By.className((String)"ref-match"));

    public RefMatcherListDisplay(@Nonnull PageElement container) {
        super(container);
        this.branchIcon = this.find(By.className((String)"ref-lozenge-icon"));
        this.inactiveLozenge = this.find(By.className((String)"inactive-lozenge"));
    }

    public RefMatcherEntry getRefMatch() {
        return new RefMatcherEntry(this.getRefType(), this.getRefPattern(), this.isActive());
    }

    private boolean isActive() {
        return !this.inactiveLozenge.isPresent();
    }

    private String getRefPattern() {
        return this.pattern.getText();
    }

    private RefMatcherEntryType getRefType() {
        String dataTestValue = this.refMatch.getAttribute("data-test-value");
        if ("BRANCH".equals(dataTestValue)) {
            return RefMatcherEntryType.BRANCH_NAME;
        }
        if ("PATTERN".equals(dataTestValue)) {
            return RefMatcherEntryType.BRANCH_PATTERN;
        }
        if ("BRANCHING_MODEL".equals(dataTestValue)) {
            return this.branchIcon.isPresent() ? RefMatcherEntryType.BRANCH_MODEL_BRANCH : RefMatcherEntryType.BRANCH_MODEL_CATEGORY;
        }
        if ("ANY_REF".equals(dataTestValue)) {
            return RefMatcherEntryType.ANY_BRANCH;
        }
        return RefMatcherEntryType.NONE;
    }
}

