/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.builds;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.builds.ActionItem;
import com.atlassian.webdriver.bitbucket.element.builds.AuthorizeBuildServerModal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openqa.selenium.By;

public class BuildActionsMenu
extends AbstractElementPageObject {
    private final PageElementFinder elementFinder;

    public BuildActionsMenu(PageElementFinder elementFinder, PageElement dropList) {
        super(dropList);
        this.elementFinder = Objects.requireNonNull(elementFinder, "elementFinder");
    }

    public boolean canAuthorize() {
        return !this.container.findAll(By.className((String)"build-action-authorize"), TimeoutType.DIALOG_LOAD).isEmpty();
    }

    public AuthorizeBuildServerModal clickAuthorize() {
        this.container.find(By.className((String)"build-action-authorize")).click();
        PageElement modal = this.elementFinder.find(By.className((String)"build-authorize-modal"));
        Poller.waitUntilTrue((TimedQuery)modal.timed().isVisible());
        return new AuthorizeBuildServerModal(this.elementFinder, modal);
    }

    public List<ActionItem> getActions() {
        return this.elementFinder.findAll(By.cssSelector((String)"[role=\"menuitem\"")).stream().map(ActionItem::new).collect(Collectors.toList());
    }
}

