/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page;

import com.atlassian.bitbucket.pageobjects.element.ProjectSettingsRestrictionSelector;
import com.atlassian.bitbucket.pageobjects.page.ScopedPermissionsPage;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;

public class ProjectPermissionsPage
extends ScopedPermissionsPage {
    @ElementBy(className="project-default-permission__control")
    private PageElement defaultPermissionControl;
    @ElementBy(className="project-default-permission__menu")
    private PageElement defaultPermissionMenu;
    @ElementBy(cssSelector=".project-default-permission__menu-list .project-default-permission__option:nth-child(4)")
    private PageElement defaultPermissionNoAccessOption;
    @ElementBy(cssSelector=".project-default-permission__menu-list .project-default-permission__option:nth-child(3)")
    private PageElement defaultPermissionReadOption;
    @ElementBy(cssSelector=".project-default-permission__menu-list .project-default-permission__option:nth-child(1)")
    private PageElement defaultPermissionRepoCreateOption;
    @ElementBy(className="project-default-permission__single-value")
    private PageElement defaultPermissionValue;
    @ElementBy(cssSelector=".project-default-permission__menu-list .project-default-permission__option:nth-child(2)")
    private PageElement defaultPermissionWriteOption;
    @ElementBy(className="project-default-permission-loading-indicator")
    private PageElement defaultPermissionsLoadingIndicator;
    @ElementBy(className="project-settings-selector")
    private PageElement defaultRestrictionDropdown;
    private String projectKey;

    public ProjectPermissionsPage(String projectKey) {
        this.projectKey = projectKey;
    }

    public ProjectDefaultPermission getDefaultPermission() {
        String selectedValue;
        switch (selectedValue = this.defaultPermissionValue.getText()) {
            case "Create repository": {
                return ProjectDefaultPermission.REPO_CREATE;
            }
            case "Write": {
                return ProjectDefaultPermission.WRITE;
            }
            case "Read": {
                return ProjectDefaultPermission.READ;
            }
            case "No access": {
                return ProjectDefaultPermission.NO_ACCESS;
            }
        }
        throw new IllegalArgumentException("Unexpected project default permission: " + selectedValue);
    }

    public ProjectSettingsRestrictionSelector getRestrictionDropdown() {
        return (ProjectSettingsRestrictionSelector)this.pageBinder.bind(ProjectSettingsRestrictionSelector.class, new Object[]{this.defaultRestrictionDropdown});
    }

    public boolean hasRestrictionDropdown() {
        return this.defaultRestrictionDropdown.isPresent();
    }

    public ProjectPermissionsPage setDefaultPermission(ProjectDefaultPermission permission) {
        Poller.waitUntilTrue((TimedQuery)this.defaultPermissionControl.timed().isVisible());
        if (!this.defaultPermissionMenu.isPresent()) {
            this.defaultPermissionControl.click();
        }
        Poller.waitUntilTrue((TimedQuery)this.defaultPermissionMenu.timed().isVisible());
        switch (permission) {
            case REPO_CREATE: {
                this.defaultPermissionRepoCreateOption.click();
                break;
            }
            case WRITE: {
                this.defaultPermissionWriteOption.click();
                break;
            }
            case READ: {
                this.defaultPermissionReadOption.click();
                break;
            }
            case NO_ACCESS: {
                this.defaultPermissionNoAccessOption.click();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown project default permission: " + permission);
            }
        }
        Poller.waitUntilFalse((TimedQuery)this.defaultPermissionsLoadingIndicator.timed().isVisible());
        return this;
    }

    public String getUrl() {
        return String.format("/projects/%s/permissions", this.projectKey);
    }

    public boolean isNoAccessPermissionDisabled() {
        Poller.waitUntilTrue((TimedQuery)this.defaultPermissionControl.timed().isVisible());
        if (!this.defaultPermissionMenu.isPresent()) {
            this.defaultPermissionControl.click();
        }
        Poller.waitUntilTrue((TimedQuery)this.defaultPermissionMenu.timed().isVisible());
        return this.defaultPermissionNoAccessOption.hasClass("project-default-permission__option--is-disabled");
    }

    public static enum ProjectDefaultPermission {
        REPO_CREATE,
        WRITE,
        READ,
        NO_ACCESS;

    }
}

