/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page;

import com.atlassian.bitbucket.pageobjects.page.ProjectAccessKeySettingsPage;
import com.atlassian.bitbucket.pageobjects.page.ScopedAccessKeyFormPage;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;

public class ProjectAccessKeyFormPage
extends ScopedAccessKeyFormPage {
    private final int accessKeyId;
    private final String projectKey;

    public ProjectAccessKeyFormPage(String projectKey) {
        this.projectKey = projectKey;
        this.accessKeyId = -1;
    }

    public ProjectAccessKeyFormPage(String projectKey, int accessKeyId) {
        this.projectKey = projectKey;
        this.accessKeyId = accessKeyId;
    }

    public ProjectAccessKeySettingsPage clickCancel() {
        Poller.waitUntilTrue((TimedQuery)this.cancelButton.timed().isVisible());
        this.cancelButton.click();
        return (ProjectAccessKeySettingsPage)this.pageBinder.bind(ProjectAccessKeySettingsPage.class, new Object[]{this.projectKey});
    }

    public ProjectAccessKeySettingsPage clickSave() {
        Poller.waitUntilTrue((TimedQuery)this.saveButton.timed().isVisible());
        this.saveButton.click();
        return (ProjectAccessKeySettingsPage)this.pageBinder.bind(ProjectAccessKeySettingsPage.class, new Object[]{this.projectKey});
    }

    public ProjectAccessKeyFormPage clickSaveGoBackToFormPage() {
        Poller.waitUntilTrue((TimedQuery)this.saveButton.timed().isVisible());
        this.saveButton.click();
        return (ProjectAccessKeyFormPage)this.pageBinder.bind(ProjectAccessKeyFormPage.class, new Object[]{this.projectKey});
    }

    public String getUrl() {
        if (this.accessKeyId == -1) {
            return String.format("/plugins/servlet/ssh/projects/%s/keys/add", this.projectKey);
        }
        return String.format("/plugins/servlet/ssh/projects/%s/keys/edit/%s", this.projectKey, this.accessKeyId);
    }

    public ProjectAccessKeyFormPage setKeyLabel(String value) {
        Poller.waitUntilTrue((TimedQuery)this.sshKeyLabel.timed().isVisible());
        Poller.waitUntilTrue((TimedQuery)this.sshKeyLabel.timed().isEnabled());
        this.sshKeyLabel.clear().type(new CharSequence[]{value});
        return this;
    }

    public ProjectAccessKeyFormPage setKeyText(String value) {
        Poller.waitUntilTrue((TimedQuery)this.sshKeyText.timed().isVisible());
        Poller.waitUntilTrue((TimedQuery)this.sshKeyText.timed().isEnabled());
        this.sshKeyText.clear().type(new CharSequence[]{value});
        return this;
    }
}

