/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class SuggestionLine
extends AbstractElementPageObject {
    private final String gutterText;
    private final String lineText;
    private final SuggestionLineType lineType;

    public SuggestionLine(@Nonnull PageElement container) {
        super(container);
        this.gutterText = container.find(By.className((String)"suggestion-gutter")).getAttribute("innerText");
        this.lineText = container.find(By.className((String)"suggestion-line")).getAttribute("innerText");
        this.lineType = container.getCssClasses().stream().findFirst().map(SuggestionLineType::fromElementClass).orElseThrow(() -> new IllegalStateException("No class on suggestion line"));
    }

    public String getGutter() {
        return this.gutterText;
    }

    public String getLineText() {
        return this.lineText;
    }

    public SuggestionLineType getLineType() {
        return this.lineType;
    }

    public static enum SuggestionLineType {
        REMOVED("removed-line"),
        ADDED("added-line");

        private final String elementClass;

        private SuggestionLineType(String elementClass) {
            this.elementClass = elementClass;
        }

        public static SuggestionLineType fromElementClass(String elementClass) {
            return EnumSet.allOf(SuggestionLineType.class).stream().filter(suggestionLineType -> suggestionLineType.elementClass.equals(elementClass)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown element class: " + elementClass));
        }
    }
}

