/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.automerge;

import com.atlassian.bitbucket.pageobjects.element.Flag;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public abstract class AbstractAutoMergeSettingsPage
extends BaseSidebarPage {
    @ElementBy(cssSelector="input[type='checkbox']")
    protected PageElement enabledCheckbox;
    @ElementBy(id="auto-merge-settings")
    private PageElement autoMergeSettingsContainer;
    @ElementBy(cssSelector="[data-testid='cancel-button']")
    private PageElement cancelButton;
    @ElementBy(cssSelector="[data-testid=\"auto-merge-checkbox--checkbox-label\"]")
    private PageElement enabledCheckboxLabel;
    @ElementBy(cssSelector="[data-testid='save-button']")
    private PageElement saveButton;

    public AbstractAutoMergeSettingsPage clickCancel() {
        Poller.waitUntilTrue((TimedQuery)this.cancelButton.timed().isEnabled());
        this.cancelButton.click();
        return this;
    }

    public AbstractAutoMergeSettingsPage clickSave() {
        Poller.waitUntilTrue((TimedQuery)this.saveButton.timed().isEnabled());
        this.saveButton.click();
        return this;
    }

    public PageElement getCancelButton() {
        Poller.waitUntilTrue((TimedQuery)this.cancelButton.timed().isVisible());
        return this.cancelButton;
    }

    public PageElement getSaveButton() {
        Poller.waitUntilTrue((TimedQuery)this.saveButton.timed().isVisible());
        return this.saveButton;
    }

    public boolean isAutoMergeEnabled() {
        return this.enabledCheckbox.isSelected();
    }

    public boolean isComponentLoaded() {
        return this.autoMergeSettingsContainer.isPresent();
    }

    public void toggleEnabled() {
        Poller.waitUntilTrue((TimedQuery)this.enabledCheckbox.timed().isPresent());
        Poller.waitUntilTrue((TimedQuery)this.enabledCheckboxLabel.timed().isPresent());
        this.enabledCheckboxLabel.click();
    }

    public void waitForSuccessFlag() {
        Flag successAlert = (Flag)((List)Poller.waitUntil(this.getAllFlags(), (Matcher)Matchers.not((Matcher)Matchers.empty()))).get(0);
        MatcherAssert.assertThat((Object)successAlert.getTitle(), (Matcher)Matchers.equalTo((Object)"Auto-merge settings updated"));
    }

    private TimedQuery<List<Flag>> getAllFlags() {
        return Queries.forSupplier((Timeouts)this.timeouts, this::getFlags);
    }
}

