/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.mesh;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.testing.PageElementMatchers;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openqa.selenium.By;

public class AsyncProjectSelector
extends AbstractElementPageObject {
    public AsyncProjectSelector(@Nonnull PageElement container) {
        super(container);
    }

    public TimedQuery<List<String>> getProjects() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> ((List)this.getDropdownList().byDefaultTimeout()).stream().map(PageElement::getText).collect(Collectors.toList()));
    }

    public AsyncProjectSelector selectProject(String project) {
        this.dropdownSelector().click();
        ((List)Poller.waitUntil(this.getDropdownList(), (Matcher)CoreMatchers.hasItem((Matcher)PageElementMatchers.withText((String)project)))).stream().filter(p -> project.equals(p.getText())).findFirst().orElseThrow(() -> new AssertionError((Object)String.format("%s not found in the project selector drop-down", project))).click();
        return this;
    }

    private PageElement dropdownSelector() {
        return this.container.find(By.className((String)"async-project-selector"));
    }

    private TimedQuery<List<PageElement>> getDropdownList() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.container.findAll(By.xpath((String)"//*[@class='async-project-selector-display']")));
    }
}

