/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.pageobjects.element.ConfirmDialog;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.requiredbuilds.RequiredBuildsForm;
import com.atlassian.webdriver.bitbucket.element.requiredbuilds.RequiredBuildsTable;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;

public class RequiredBuildsPage
extends BaseSidebarPage {
    public static final String ADD_FLAG_TITLE = "Requirement successfully added";
    public static final String EDIT_FLAG_TITLE = "Requirement successfully edited";
    public static final String DELETE_FLAG_TITLE = "Requirement successfully deleted";
    private final String projectKey;
    private final String repoSlug;
    @ElementBy(className="required-builds-table")
    private PageElement requiredBuildsTable;
    @ElementBy(cssSelector="[data-testid='add-required-builds']")
    private PageElement addRequiredBuildsBtn;
    @ElementBy(className="required-builds-form")
    private PageElement requiredBuildsForm;
    @ElementBy(cssSelector="[data-testid='delete-required-builds-modal']")
    private PageElement deleteModal;

    public RequiredBuildsPage(String projectKey, String repoSlug) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
    }

    public RequiredBuildsTable getTable() {
        return (RequiredBuildsTable)this.pageBinder.bind(RequiredBuildsTable.class, new Object[]{this.requiredBuildsTable});
    }

    public RequiredBuildsForm clickAdd() {
        this.addRequiredBuildsBtn.click();
        return this.getForm();
    }

    public RequiredBuildsForm getForm() {
        return (RequiredBuildsForm)this.pageBinder.bind(RequiredBuildsForm.class, new Object[]{this.requiredBuildsForm});
    }

    public void confirmDelete() {
        ((ConfirmDialog)this.pageBinder.bind(ConfirmDialog.class, new Object[]{this.deleteModal})).clickButton("Delete");
    }

    public String getUrl() {
        return "projects/" + this.projectKey + "/repos/" + this.repoSlug + "/settings/required-builds";
    }
}

