/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page.next;

import com.atlassian.bitbucket.pageobjects.page.next.CompareAndCreatePage;
import com.atlassian.bitbucket.pageobjects.page.next.PullRequestCreatePage;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;

public class ComparePage
extends CompareAndCreatePage<ComparePage> {
    private final String sourceProjectKey;
    private final String sourceRepoSlug;
    private String source;
    private Tab tab;
    private String target;

    public ComparePage(String sourceProjectKey, String sourceRepoSlug) {
        super(sourceProjectKey, sourceRepoSlug);
        this.sourceProjectKey = sourceProjectKey;
        this.sourceRepoSlug = sourceRepoSlug;
    }

    public ComparePage(String sourceProjectKey, String sourceRepoSlug, String source, String target) {
        this(sourceProjectKey, sourceRepoSlug);
        this.source = source;
        this.target = target;
    }

    public ComparePage(String sourceProjectKey, String sourceRepoSlug, Tab tab) {
        this(sourceProjectKey, sourceRepoSlug);
        this.tab = tab;
    }

    public PullRequestCreatePage clickCreatePullRequest() {
        Poller.waitUntilTrue((TimedQuery)this.isCreatePullRequestEnabled());
        this.getContinueButton().click();
        return (PullRequestCreatePage)this.pageBinder.bind(PullRequestCreatePage.class, new Object[]{this.sourceProjectKey, this.sourceRepoSlug});
    }

    public String getUrl() {
        StringBuilder urlBuilder = new StringBuilder();
        if (this.sourceProjectKey.startsWith("~")) {
            urlBuilder.append(String.format("/users/%s/repos/%s/compare", this.sourceProjectKey.substring(1), this.sourceRepoSlug));
        } else {
            urlBuilder.append(String.format("/projects/%s/repos/%s/compare", this.sourceProjectKey, this.sourceRepoSlug));
        }
        if (Tab.COMMITS.equals((Object)this.tab)) {
            urlBuilder.append("/commits");
        } else if (Tab.DIFF.equals((Object)this.tab)) {
            urlBuilder.append("/diff");
        }
        if (this.source != null || this.target != null) {
            urlBuilder.append(String.format("?sourceBranch=%s&targetBranch=%s", this.source, this.target));
        }
        return urlBuilder.toString();
    }

    public TimedCondition isCreatePullRequestEnabled() {
        return this.getContinueButton().timed().isEnabled();
    }

    public static enum Tab {
        COMMITS,
        DIFF;

    }
}

