/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page;

import com.atlassian.bitbucket.pageobjects.page.UserAccountSshKeyFormPage;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AccessKeyRow;
import com.atlassian.webdriver.bitbucket.element.UserAccountSshKeyRow;
import com.atlassian.webdriver.bitbucket.page.UserAccountAddSshKeyPage;
import com.atlassian.webdriver.bitbucket.page.UserAccountSettingsPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.Locators;
import java.util.List;

public class UserAccountSshSettingsPage
extends UserAccountSettingsPage {
    @ElementBy(className="ssh-keys-table")
    private PageElement sshKeysTable;
    @ElementBy(className="add-key-button")
    private PageElement addKeyButton;
    @ElementBy(cssSelector="[data-testid='ssh-key-actions-edit']")
    private PageElement sshKeyActionsEdit;

    @Init
    public void init() {
        ElementUtils.displayAllDeleteButtons(this.javascriptExecutor);
    }

    @Override
    public String getUrl() {
        return "/plugins/servlet/ssh/account/keys";
    }

    public List<UserAccountSshKeyRow> getSshKeys() {
        return this.sshKeysTable.findAll(Locators.tableRow(), UserAccountSshKeyRow.class);
    }

    public UserAccountAddSshKeyPage clickAddKey() {
        this.waitForPageLoad(new Runnable(){

            @Override
            public void run() {
                UserAccountSshSettingsPage.this.addKeyButton.click();
            }
        });
        return (UserAccountAddSshKeyPage)this.pageBinder.bind(UserAccountAddSshKeyPage.class, new Object[0]);
    }

    public UserAccountSshKeyFormPage clickEditByKeyId(int keyId) {
        Poller.waitUntilTrue((TimedQuery)this.isSshKeysTablePresent());
        AccessKeyRow accessKeyRow = this.getAccessKeys().get(0);
        accessKeyRow.openDropdown();
        Poller.waitUntilTrue((TimedQuery)this.isDropdownVisible());
        this.sshKeyActionsEdit.click();
        return (UserAccountSshKeyFormPage)this.pageBinder.bind(UserAccountSshKeyFormPage.class, new Object[]{keyId});
    }

    public List<AccessKeyRow> getAccessKeys() {
        return this.sshKeysTable.findAll(Locators.tableRow(), AccessKeyRow.class);
    }

    public TimedCondition isDropdownVisible() {
        return this.sshKeyActionsEdit.timed().isVisible();
    }

    public boolean isEmpty() {
        return !this.sshKeysTable.isPresent();
    }

    public TimedCondition isSshKeysTablePresent() {
        return this.sshKeysTable.timed().isPresent();
    }

    public UserAccountSshKeyFormPage clickAddKeyButton() {
        Poller.waitUntilTrue((TimedQuery)this.addKeyButton.timed().isVisible());
        this.addKeyButton.click();
        return (UserAccountSshKeyFormPage)this.pageBinder.bind(UserAccountSshKeyFormPage.class, new Object[0]);
    }

    public void waitUntilLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.sshKeysTable.timed().isVisible());
    }
}

