/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page;

import com.atlassian.bitbucket.pageobjects.element.Changes;
import com.atlassian.bitbucket.pageobjects.page.PullRequestPage;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import org.apache.commons.lang3.StringUtils;

public abstract class PullRequestDiffPage
extends PullRequestPage<PullRequestDiffPage> {
    private final String path;
    private final String queryParams;
    @ElementBy(className="changes")
    private PageElement changes;
    @ElementBy(className="commit-selector__control")
    private PageElement commitSelector;

    public PullRequestDiffPage(String projectKey, String slug, long pullRequestId) {
        super(projectKey, slug, pullRequestId);
        this.path = null;
        this.queryParams = null;
    }

    public PullRequestDiffPage(String projectKey, String slug, long pullRequestId, String sinceHash) {
        super(projectKey, slug, pullRequestId);
        this.path = null;
        this.queryParams = UrlUtils.buildQueryParams((Object[])new Object[]{"since", sinceHash});
    }

    public PullRequestDiffPage(String projectKey, String slug, long pullRequestId, long commentId, String action) {
        super(projectKey, slug, pullRequestId);
        this.queryParams = UrlUtils.buildQueryParams((Object[])new Object[]{"commentId", commentId, "action", action});
        this.path = null;
    }

    public PullRequestDiffPage(String projectKey, String slug, long pullRequestId, String sinceHash, long commentId, String action) {
        super(projectKey, slug, pullRequestId);
        this.queryParams = UrlUtils.buildQueryParams((Object[])new Object[]{"since", sinceHash, "commentId", commentId, "action", action});
        this.path = null;
    }

    public PullRequestDiffPage(String projectKey, String slug, long pullRequestId, String path, Integer annotationLineNumber) {
        super(projectKey, slug, pullRequestId);
        this.queryParams = annotationLineNumber != null ? "T" + annotationLineNumber : null;
        this.path = path;
    }

    public Changes getChanges() {
        return (Changes)this.pageBinder.bind(Changes.class, new Object[]{this.changes});
    }

    public String getCommitSelectorText() {
        return (String)this.commitSelector.timed().getText().byDefaultTimeout();
    }

    public abstract String getDiffUrl();

    @Override
    public String getUrl() {
        String url = super.getUrl() + this.getDiffUrl();
        if (StringUtils.isNotBlank((CharSequence)this.path)) {
            url = url + "#" + this.path;
        }
        if (StringUtils.isNotBlank((CharSequence)this.queryParams)) {
            url = url + "?" + this.queryParams;
        }
        return url;
    }

    public PullRequestDiffPage toggleOverview() {
        this.navigateToOverviewPage().getPullRequestTabs().getDiffTab().withTimeout(TimeoutType.UI_ACTION).click();
        return this;
    }

    public void viewSideBySideDiff() {
        this.getChanges().getDiffFileContent().getToolbar().viewSideBySideDiff();
    }

    public void viewUnifiedDiff() {
        this.getChanges().getDiffFileContent().getToolbar().viewUnifiedDiff();
    }
}

