/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class KeywordsInput
extends AbstractElementPageObject {
    private final PageElement input = this.find(By.cssSelector((String)"input[type='text']"));

    public KeywordsInput(@Nonnull PageElement container) {
        super(container);
    }

    public KeywordsInput addValue(String value) {
        this.input.clear().type(new CharSequence[]{value}).type(new CharSequence[]{Keys.ENTER});
        return this;
    }

    public List<String> getValues() {
        return (List)this.container.findAll(By.className((String)"keywords-input__multi-value")).stream().map(ElementUtils.bind(this.pageBinder, KeywordValue.class, new Object[0])).map(KeywordValue::getText).collect(MoreCollectors.toImmutableList());
    }

    public KeywordsInput removeValue(String value) {
        KeywordValue keyword = this.container.findAll(By.className((String)"keywords-input__multi-value")).stream().map(ElementUtils.bind(this.pageBinder, KeywordValue.class, new Object[0])).filter(item -> item.getText().equals(value)).findFirst().orElseThrow(() -> new AssertionError((Object)("No keyword has the value " + value)));
        keyword.clickRemove();
        return this;
    }

    public static class KeywordValue
    extends AbstractElementPageObject {
        private final PageElement label = this.find(By.className((String)"keywords-input__multi-value__label"));
        private final PageElement removeButton = this.find(By.className((String)"keywords-input__multi-value__remove"));

        public KeywordValue(@Nonnull PageElement container) {
            super(container);
        }

        public void clickRemove() {
            this.removeButton.click();
        }

        public String getText() {
            return this.label.getText();
        }
    }
}

