/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.page.PullRequestOverviewPage;
import com.atlassian.bitbucket.pageobjects.page.PullRequestPage;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class CommitSuggestionDialog
extends AbstractElementPageObject {
    private final PageElement commitButton = this.find(By.cssSelector((String)"[type='submit']"));
    private final PageElement commitDescription = this.find(By.tagName((String)"textarea"));
    private final PageElement commitSubject = this.find(By.id((String)"commit-message-title"));

    public CommitSuggestionDialog(@Nonnull PageElementFinder elementFinder) {
        super(elementFinder.find(By.cssSelector((String)"[data-testid='commit-suggestion-dialog']")));
        Poller.waitUntilTrue((TimedQuery)this.container.timed().isVisible());
    }

    public PullRequestOverviewPage clickCommit(PullRequestPage page, long commentId) {
        this.commitButton.click();
        Poller.waitUntil((String)"The spinner has stopped spinning", (TimedQuery)this.commitButton.timed().hasAttribute("data-has-overlay", "true"), (Matcher)Matchers.is((Object)false), (Poller.WaitTimeout)Poller.by((long)20L, (TimeUnit)TimeUnit.SECONDS));
        PullRequestOverviewPage overviewPage = (PullRequestOverviewPage)this.pageBinder.bind(PullRequestOverviewPage.class, new Object[]{page.getProjectKey(), page.getSlug(), page.getPullRequestId(), commentId, null});
        overviewPage.waitUntilPageLoaded();
        return overviewPage;
    }

    public String getCommitSubject() {
        return this.commitSubject.getValue();
    }

    public CommitSuggestionDialog setCommitSubject(String subject) {
        this.commitSubject.type(new CharSequence[]{subject});
        return this;
    }

    public CommitSuggestionDialog setCommitDescription(String description) {
        this.commitDescription.type(new CharSequence[]{description});
        return this;
    }
}

