/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.element.DiffCommitSelector;
import com.atlassian.bitbucket.pageobjects.element.DiffFileContent;
import com.atlassian.bitbucket.pageobjects.element.DiffSearchResults;
import com.atlassian.bitbucket.pageobjects.element.FileTree;
import com.atlassian.bitbucket.pageobjects.element.codeinsights.CodeInsightsDiffAnnotation;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.AbstractTimedCondition;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class Changes
extends AbstractElementPageObject {
    private final PageElement changesFilterInput = this.find(By.cssSelector((String)".changes-filter-input input"));
    private final PageElement changesSearchInput = this.find(By.cssSelector((String)".changes-search-input input"));
    private final PageElement commitSelector = this.find(By.className((String)"commit-selector"));
    private final PageElement diffActions;
    private final PageElement diffFileContent = this.find(By.className((String)"change-view"));
    private final PageElement diffSearchResults = this.find(By.className((String)"changes-search-results"));
    private final PageElement fileTree = this.find(By.className((String)"changes-tree"));
    private final PageElement filterFileTreeButton = this.find(By.cssSelector((String)"[data-testid='filter-action-button']"));
    private final PageElement searchCodeButton = this.find(By.cssSelector((String)"[data-testid='search-action-button']"));

    public Changes(@Nonnull PageElement container) {
        super(container);
        this.diffActions = this.find(By.cssSelector((String)".diff-actions"));
        this.waitUntilLoaded();
    }

    public FileTree filterFileTree(String query) {
        this.waitForTreeUpdate(() -> {
            this.filterFileTreeButton.click();
            this.changesFilterInput.withTimeout(TimeoutType.UI_ACTION).type(new CharSequence[]{query});
        });
        return this.getFileTree();
    }

    public List<CodeInsightsDiffAnnotation> getAllAnnotations() {
        return this.container.findAll(By.cssSelector((String)".additional-diff-content, .diff-segment > tr")).stream().map(annotationContainer -> {
            if (annotationContainer.getCssClasses().contains("additional-diff-content")) {
                return (CodeInsightsDiffAnnotation)this.pageBinder.bind(CodeInsightsDiffAnnotation.class, new Object[]{this.extractAnnotation((PageElement)annotationContainer)});
            }
            String lineNumberText = annotationContainer.find(By.cssSelector((String)"a[data-line-number]")).getText();
            int line = Integer.parseInt(lineNumberText.replaceAll("[^0-9]", ""));
            return this.getAnnotationOnLine(line).orElse(null);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Optional<CodeInsightsDiffAnnotation> getAnnotationOnLine(int lineNumber) {
        return this.container.findAll(By.cssSelector((String)".diff-segment > tr")).stream().filter(row -> row.find(By.cssSelector((String)("a[data-line-number^=\"" + lineNumber + " \"]"))).isPresent()).findFirst().map(rowI -> {
            PageElement annotationContainer = this.extractAnnotation((PageElement)rowI);
            return annotationContainer.isPresent() ? (CodeInsightsDiffAnnotation)this.pageBinder.bind(CodeInsightsDiffAnnotation.class, new Object[]{annotationContainer, lineNumber}) : null;
        });
    }

    public DiffCommitSelector getCommitSelector() {
        return (DiffCommitSelector)this.pageBinder.bind(DiffCommitSelector.class, new Object[]{this.commitSelector});
    }

    public PageElement getDiffActionsCSE(String text) {
        Poller.waitUntilTrue((TimedQuery)this.diffActions.timed().isVisible());
        return this.diffActions.find(By.xpath((String)("//*[.=('" + text + "')]")));
    }

    public DiffFileContent getDiffFileContent() {
        return (DiffFileContent)this.pageBinder.bind(DiffFileContent.class, new Object[]{this.diffFileContent});
    }

    public List<CodeInsightsDiffAnnotation> getFileLevelAnnotations() {
        return this.container.findAll(By.cssSelector((String)".diff-file-annotations .diff-annotation")).stream().map(it -> (CodeInsightsDiffAnnotation)this.pageBinder.bind(CodeInsightsDiffAnnotation.class, new Object[]{it})).collect(Collectors.toList());
    }

    public FileTree getFileTree() {
        return (FileTree)this.pageBinder.bind(FileTree.class, new Object[]{this.fileTree});
    }

    public TimedQuery<Boolean> hasAnnotations() {
        return this.find(By.className((String)"diff-annotation")).timed().isVisible();
    }

    public void resetFileTreeFiltering() {
        this.waitForTreeUpdate(() -> ((PageElement)this.filterFileTreeButton).click());
    }

    public DiffSearchResults searchDiff(String query) {
        this.searchCodeButton.click();
        this.changesSearchInput.withTimeout(TimeoutType.UI_ACTION).type(new CharSequence[]{query});
        Poller.waitUntilTrue((TimedQuery)this.diffSearchResults.timed().isVisible());
        return (DiffSearchResults)this.pageBinder.bind(DiffSearchResults.class, new Object[]{this.diffSearchResults});
    }

    public void stopDiffSearch() {
        this.searchCodeButton.click();
        Poller.waitUntilTrue((TimedQuery)this.fileTree.timed().isVisible());
    }

    public void waitUntilLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.fileTree.withTimeout(TimeoutType.PAGE_LOAD).timed().isPresent());
        Poller.waitUntilTrue((TimedQuery)this.diffFileContent.withTimeout(TimeoutType.PAGE_LOAD).timed().isPresent());
    }

    private PageElement extractAnnotation(PageElement from) {
        return from.find(By.className((String)"diff-annotation"));
    }

    private void waitForTreeUpdate(Runnable runnable) {
        final int initialCount = this.getFileTree().getFiles().size();
        runnable.run();
        Poller.waitUntilTrue((String)"The number of files has changed", (TimedQuery)new AbstractTimedCondition(2000L, 400L){

            protected Boolean currentValue() {
                return Changes.this.getFileTree().getFiles().size() != initialCount;
            }
        });
    }
}

